/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;

public class SnippetAutoTitleFeature
implements PluginFeature {
    public static final PluginParamsDefinition paramsDefinition = SnippetAutoTitleFeature.createParamsDefinition();
    private static final String TITLE_KEY = "title";
    private static final String AUTO_TITLE_KEY = "autoTitle";
    private final String snippetId;

    public SnippetAutoTitleFeature(String snippetId) {
        this.snippetId = snippetId;
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        if (props.containsKey(TITLE_KEY) && props.containsKey(AUTO_TITLE_KEY)) {
            throw new IllegalArgumentException("Can't have both <title> and <autoTitle> specified");
        }
        Object autoTitle = props.get(AUTO_TITLE_KEY);
        if (autoTitle == null) {
            return;
        }
        if (Boolean.TRUE.equals(autoTitle)) {
            props.put(TITLE_KEY, this.snippetId);
        }
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles() {
        return Stream.empty();
    }

    private static PluginParamsDefinition createParamsDefinition() {
        return new PluginParamsDefinition().add(AUTO_TITLE_KEY, PluginParamType.BOOLEAN, "use snippet path as automatic title", "true");
    }
}

