/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.toc;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;

public class PageTocIncludePlugin
implements IncludePlugin {
    @Override
    public String id() {
        return "page-toc";
    }

    @Override
    public IncludePlugin create() {
        return new PageTocIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        TableOfContents toc = componentsRegistry.docStructure().tableOfContents();
        TocItem tocItem = toc.findTocItem(markupPath);
        if (tocItem == null) {
            throw new IllegalStateException("File is not part of TOC: " + markupPath.toAbsolutePath());
        }
        LinkedHashMap<String, Supplier<Object>> props = new LinkedHashMap<String, Supplier<Object>>();
        Supplier<Object> buildSectionsSupplier = () -> this.buildSections(tocItem);
        props.put("sections", buildSectionsSupplier);
        return PluginResult.docElement("PageToc", props);
    }

    private List<Map<String, ?>> buildSections(TocItem tocItem) {
        return tocItem.getPageSectionIdTitles().stream().map(PageSectionIdTitle::toMap).collect(Collectors.toList());
    }
}

