/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.java.extensions;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.api.ApiLinkedText;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.java.extensions.JavaIncludePluginBase;
import org.testingisdocumenting.znai.java.extensions.JavaIncludeResult;
import org.testingisdocumenting.znai.java.parser.EnumEntry;
import org.testingisdocumenting.znai.java.parser.JavaCode;
import org.testingisdocumenting.znai.parser.docelement.DocElement;

public class JavaEnumEntriesIncludePlugin
extends JavaIncludePluginBase {
    private static final String EXCLUDE_DEPRECATED_KEY = "excludeDeprecated";

    @Override
    public String id() {
        return "java-enum-entries";
    }

    @Override
    public IncludePlugin create() {
        return new JavaEnumEntriesIncludePlugin();
    }

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add("title", PluginParamType.STRING, "title to use for parameters block", "\"myMethod parameters\"").add(EXCLUDE_DEPRECATED_KEY, PluginParamType.BOOLEAN, "exclude deprecated entries from the list", "true").add(CodeReferencesFeature.paramsDefinition);
    }

    @Override
    public JavaIncludeResult process(JavaCode javaCode) {
        ApiParameters apiParameters = new ApiParameters(this.determineAnchorPrefix());
        javaCode.getEnumEntries().stream().filter(this::includeEnum).forEach(enumEntry -> {
            JavaIncludePluginBase.JavaDocElementsMapsAndSearchText elementsMapsAndSearchText = this.javaDocTextToDocElements(enumEntry.getJavaDocText());
            apiParameters.add(enumEntry.getName(), new ApiLinkedText(), elementsMapsAndSearchText.docElementsMaps, elementsMapsAndSearchText.searchText);
        });
        Map<String, Object> props = apiParameters.toMap();
        this.features.updateProps(props);
        props.putAll(this.pluginParams.getOpts().toMap());
        List<DocElement> docElements = PluginResult.docElement("ApiParameters", props).getDocElements();
        return new JavaIncludeResult(docElements, this.extractText(javaCode.getEnumEntries()));
    }

    private boolean includeEnum(EnumEntry enumEntry) {
        boolean excludeDeprecated = this.pluginParams.getOpts().get(EXCLUDE_DEPRECATED_KEY, false);
        return !excludeDeprecated || !enumEntry.isDeprecated();
    }

    private String extractText(List<EnumEntry> enums) {
        return enums.stream().map(e -> e.getName() + " " + e.getJavaDocText()).collect(Collectors.joining(" "));
    }

    private String determineAnchorPrefix() {
        if (!this.entries.isEmpty()) {
            return (String)this.entries.get(0);
        }
        return this.fullPath.getFileName().toString();
    }
}

