/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.python;

import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.features.PluginFeatureList;
import org.testingisdocumenting.znai.extensions.file.CodeReferencesFeature;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.python.Python;
import org.testingisdocumenting.znai.python.PythonContext;
import org.testingisdocumenting.znai.python.PythonIncludeResult;
import org.testingisdocumenting.znai.python.PythonParsedEntry;
import org.testingisdocumenting.znai.python.PythonParsedFile;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public abstract class PythonIncludePluginBase
implements IncludePlugin {
    private PythonIncludeResult pythonResult;
    protected Path fullPath;
    protected ComponentsRegistry componentsRegistry;
    protected PluginParams pluginParams;
    protected PluginFeatureList features;
    protected CodeReferencesFeature codeReferencesFeature;
    protected ResourcesResolver resourcesResolver;

    public abstract PythonIncludeResult process(PythonParsedFile var1, ParserHandler var2, Path var3);

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.componentsRegistry = componentsRegistry;
        this.resourcesResolver = componentsRegistry.resourceResolver();
        this.pluginParams = pluginParams;
        String fileNameToUse = this.fileNameToUse();
        this.fullPath = this.resourcesResolver.fullPath(fileNameToUse);
        this.codeReferencesFeature = new CodeReferencesFeature(componentsRegistry, markupPath, pluginParams);
        this.features = new PluginFeatureList(this.codeReferencesFeature);
        PythonContext context = new PythonContext(fileNameToUse, this.defaultPackageName());
        PythonParsedFile pythonParseResult = Python.INSTANCE.parseFileOrGetCached(this.fullPath, context);
        this.pythonResult = this.process(pythonParseResult, parserHandler, markupPath);
        return PluginResult.docElements(this.pythonResult.getDocElements().stream());
    }

    protected String getEntryName() {
        return this.pluginParams.getOpts().getRequiredString("entry");
    }

    protected String snippetIdToUse() {
        return this.pluginParams.getFreeParam();
    }

    protected Stream<String> additionalAuxiliaryFileNames() {
        return Stream.empty();
    }

    protected String defaultPackageName() {
        return this.pluginParams.getOpts().get("packageName", "");
    }

    protected String fileNameToUse() {
        return this.pluginParams.getFreeParam();
    }

    protected PythonParsedEntry findEntryByName(PythonParsedFile parsed, String name) {
        PythonParsedEntry entry = parsed.findEntryByName(name);
        if (entry == null) {
            throw new RuntimeException("can't find entry: " + name + " in: " + this.snippetIdToUse() + ", available entries: " + parsed.namesStream().collect(Collectors.joining(", ")));
        }
        return entry;
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.fullPath)), this.additionalAuxiliaryFileNames().map(fileName -> AuxiliaryFile.builtTime(this.resourcesResolver.fullPath((String)fileName))));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.HIGH.text(this.pythonResult.getText());
    }
}

