/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.util.ArrayList;
import java.util.List;
import smetana.core.CType;
import smetana.core.JUtils;

public class CEnumInterpretor {
    private final List<String> keys = new ArrayList<String>();
    private String keyRef;
    private int valueRef;

    public CEnumInterpretor(Class enumClass) {
        List<String> def = CType.getDefinition(enumClass);
        JUtils.LOG("def1=" + def);
        if (!def.get(0).equals("typedef enum")) {
            throw new IllegalArgumentException();
        }
        if (!def.get(1).equals("{")) {
            throw new IllegalArgumentException();
        }
        if (!def.get(def.size() - 2).equals("}")) {
            throw new IllegalArgumentException();
        }
        def = def.subList(2, def.size() - 2);
        JUtils.LOG("def2=" + def);
        for (String s1 : def) {
            for (String s2 : s1.split(",")) {
                int idx = (s2 = s2.trim()).indexOf(61);
                String k = idx == -1 ? s2 : s2.substring(0, idx);
                this.keys.add(k.trim());
                if (idx == -1) continue;
                if (this.keyRef != null) {
                    throw new IllegalStateException();
                }
                this.keyRef = k.trim();
                this.valueRef = Integer.parseInt(s2.substring(idx + 1).trim());
            }
        }
        JUtils.LOG("keys=" + this.keys);
    }

    public int valueOf(String name) {
        JUtils.LOG("keys=" + this.keys);
        int idx = this.keys.indexOf(name);
        if (idx == -1) {
            throw new IllegalArgumentException(name + " is no enum value");
        }
        if (this.keyRef == null) {
            return idx;
        }
        int keyRefIndex = this.keys.indexOf(this.keyRef);
        if (keyRefIndex == -1) {
            throw new IllegalStateException();
        }
        return idx - keyRefIndex + this.valueRef;
    }
}

