/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.examples;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.cfg.ValidationConfiguration;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.processing.Processor;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.jsonschema.examples.Utils;
import znaishaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import znaishaded.com.github.fge.jsonschema.keyword.digest.Digester;
import znaishaded.com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import znaishaded.com.github.fge.jsonschema.library.DraftV4Library;
import znaishaded.com.github.fge.jsonschema.library.Keyword;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.main.JsonSchema;
import znaishaded.com.github.fge.jsonschema.main.JsonSchemaFactory;
import znaishaded.com.github.fge.jsonschema.messages.JsonSchemaValidationBundle;
import znaishaded.com.github.fge.jsonschema.processors.data.FullData;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;
import znaishaded.com.github.fge.msgsimple.source.MapMessageSource;
import znaishaded.com.github.fge.msgsimple.source.MessageSource;
import znaishaded.com.google.common.collect.ImmutableList;
import znaishaded.com.google.common.collect.Lists;
import znaishaded.com.google.common.collect.Sets;

public final class Example9 {
    public static void main(String ... args) throws IOException, ProcessingException {
        JsonNode customSchema = Utils.loadResource("/custom-keyword.json");
        JsonNode good = Utils.loadResource("/custom-keyword-good.json");
        JsonNode bad = Utils.loadResource("/custom-keyword-bad.json");
        Keyword keyword = Keyword.newBuilder("divisors").withSyntaxChecker(DivisorsSyntaxChecker.getInstance()).withDigester(DivisorsDigesters.getInstance()).withValidatorClass(DivisorsKeywordValidator.class).freeze();
        Library library = DraftV4Library.get().thaw().addKeyword(keyword).freeze();
        String key = "missingDivisors";
        String value = "integer value is not a multiple of all divisors";
        MessageSource source = MapMessageSource.newBuilder().put("missingDivisors", "integer value is not a multiple of all divisors").build();
        MessageBundle bundle = MessageBundles.getBundle(JsonSchemaValidationBundle.class).thaw().appendSource(source).freeze();
        ValidationConfiguration cfg = ValidationConfiguration.newBuilder().setDefaultLibrary("http://my.site/myschema#", library).setValidationMessages(bundle).freeze();
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().setValidationConfiguration(cfg).freeze();
        JsonSchema schema = factory.getJsonSchema(customSchema);
        ProcessingReport report = schema.validate(good);
        System.out.println(report);
        report = schema.validate(bad);
        System.out.println(report);
    }

    public static final class DivisorsKeywordValidator
    extends AbstractKeywordValidator {
        private final List<BigInteger> divisors;

        public DivisorsKeywordValidator(JsonNode digest) {
            super("divisors");
            ImmutableList.Builder list = ImmutableList.builder();
            for (JsonNode element : digest) {
                list.add(element.bigIntegerValue());
            }
            this.divisors = list.build();
        }

        @Override
        public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle, FullData data) throws ProcessingException {
            BigInteger value = data.getInstance().getNode().bigIntegerValue();
            ArrayList<BigInteger> failed = Lists.newArrayList();
            for (BigInteger divisor : this.divisors) {
                if (value.mod(divisor).equals(BigInteger.ZERO)) continue;
                failed.add(divisor);
            }
            if (failed.isEmpty()) {
                return;
            }
            report.error(this.newMsg(data, bundle, "missingDivisors").put("divisors", this.divisors).put("failed", failed));
        }

        @Override
        public String toString() {
            return "divisors: " + this.divisors;
        }
    }

    private static final class DivisorsDigesters
    extends AbstractDigester {
        private static final Digester INSTANCE = new DivisorsDigesters();
        private static final Comparator<JsonNode> COMPARATOR = new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.bigIntegerValue().compareTo(o2.bigIntegerValue());
            }
        };

        public static Digester getInstance() {
            return INSTANCE;
        }

        private DivisorsDigesters() {
            super("divisors", NodeType.INTEGER, new NodeType[0]);
        }

        @Override
        public JsonNode digest(JsonNode schema) {
            TreeSet<JsonNode> set = Sets.newTreeSet(COMPARATOR);
            for (JsonNode element : schema.get(this.keyword)) {
                set.add(element);
            }
            return FACTORY.arrayNode().addAll(set);
        }
    }

    private static final class DivisorsSyntaxChecker
    extends AbstractSyntaxChecker {
        private static final SyntaxChecker INSTANCE = new DivisorsSyntaxChecker();

        public static SyntaxChecker getInstance() {
            return INSTANCE;
        }

        private DivisorsSyntaxChecker() {
            super("divisors", NodeType.ARRAY, new NodeType[0]);
        }

        @Override
        protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
            JsonNode node = this.getNode(tree);
            int size = node.size();
            if (size == 0) {
                report.error(this.newMsg(tree, bundle, "emptyArray"));
                return;
            }
            boolean uniqueItems = true;
            HashSet<JsonNode> set = Sets.newHashSet();
            for (int index = 0; index < size; ++index) {
                JsonNode element = node.get(index);
                NodeType type = NodeType.getNodeType(element);
                if (type != NodeType.INTEGER) {
                    report.error(this.newMsg(tree, bundle, "incorrectElementType").put("expected", NodeType.INTEGER).put("found", type));
                } else if (element.bigIntegerValue().compareTo(BigInteger.ONE) < 0) {
                    report.error(this.newMsg(tree, bundle, "integerIsNegative").put("value", element));
                }
                uniqueItems = set.add(element);
            }
            if (!uniqueItems) {
                report.error(this.newMsg(tree, bundle, "elementsNotUnique"));
            }
        }
    }
}

