/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.library;

import znaishaded.com.github.fge.Thawed;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.util.Dictionary;
import znaishaded.com.github.fge.jsonschema.core.util.DictionaryBuilder;
import znaishaded.com.github.fge.jsonschema.format.FormatAttribute;
import znaishaded.com.github.fge.jsonschema.keyword.digest.Digester;
import znaishaded.com.github.fge.jsonschema.keyword.validator.KeywordValidatorFactory;
import znaishaded.com.github.fge.jsonschema.library.Keyword;
import znaishaded.com.github.fge.jsonschema.library.Library;
import znaishaded.com.github.fge.jsonschema.messages.JsonSchemaConfigurationBundle;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;

public final class LibraryBuilder
implements Thawed<Library> {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaConfigurationBundle.class);
    final DictionaryBuilder<SyntaxChecker> syntaxCheckers;
    final DictionaryBuilder<Digester> digesters;
    final DictionaryBuilder<KeywordValidatorFactory> validators;
    final DictionaryBuilder<FormatAttribute> formatAttributes;

    LibraryBuilder() {
        this.syntaxCheckers = Dictionary.newBuilder();
        this.digesters = Dictionary.newBuilder();
        this.validators = Dictionary.newBuilder();
        this.formatAttributes = Dictionary.newBuilder();
    }

    LibraryBuilder(Library library) {
        this.syntaxCheckers = library.syntaxCheckers.thaw();
        this.digesters = library.digesters.thaw();
        this.validators = library.validators.thaw();
        this.formatAttributes = library.formatAttributes.thaw();
    }

    public LibraryBuilder addKeyword(Keyword keyword) {
        BUNDLE.checkNotNull(keyword, "nullKeyword");
        String name = keyword.name;
        this.removeKeyword(name);
        this.syntaxCheckers.addEntry(name, keyword.syntaxChecker);
        if (keyword.validatorFactory != null) {
            this.digesters.addEntry(name, keyword.digester);
            this.validators.addEntry(name, keyword.validatorFactory);
        }
        return this;
    }

    public LibraryBuilder removeKeyword(String name) {
        BUNDLE.checkNotNull(name, "nullName");
        this.syntaxCheckers.removeEntry(name);
        this.digesters.removeEntry(name);
        this.validators.removeEntry(name);
        return this;
    }

    public LibraryBuilder addFormatAttribute(String name, FormatAttribute attribute) {
        this.removeFormatAttribute(name);
        BUNDLE.checkNotNullPrintf(attribute, "nullAttribute", name);
        this.formatAttributes.addEntry(name, attribute);
        return this;
    }

    public LibraryBuilder removeFormatAttribute(String name) {
        BUNDLE.checkNotNull(name, "nullFormat");
        this.formatAttributes.removeEntry(name);
        return this;
    }

    @Override
    public Library freeze() {
        return new Library(this);
    }
}

