/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.uritemplate.parse;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.msgsimple.load.MessageBundles;
import znaishaded.com.github.fge.uritemplate.URITemplateMessageBundle;
import znaishaded.com.github.fge.uritemplate.URITemplateParseException;
import znaishaded.com.github.fge.uritemplate.expression.URITemplateExpression;
import znaishaded.com.github.fge.uritemplate.parse.CharMatchers;
import znaishaded.com.github.fge.uritemplate.parse.ExpressionParser;
import znaishaded.com.github.fge.uritemplate.parse.LiteralParser;
import znaishaded.com.github.fge.uritemplate.parse.TemplateParser;
import znaishaded.com.google.common.annotations.VisibleForTesting;
import znaishaded.com.google.common.base.CharMatcher;
import znaishaded.com.google.common.collect.Lists;

public final class URITemplateParser {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(URITemplateMessageBundle.class);
    private static final CharMatcher BEGIN_EXPRESSION = CharMatcher.is('{');

    private URITemplateParser() {
    }

    public static List<URITemplateExpression> parse(String input) throws URITemplateParseException {
        return URITemplateParser.parse(CharBuffer.wrap(input).asReadOnlyBuffer());
    }

    @VisibleForTesting
    static List<URITemplateExpression> parse(CharBuffer buffer) throws URITemplateParseException {
        ArrayList<URITemplateExpression> ret = Lists.newArrayList();
        while (buffer.hasRemaining()) {
            TemplateParser templateParser = URITemplateParser.selectParser(buffer);
            URITemplateExpression expression = templateParser.parse(buffer);
            ret.add(expression);
        }
        return ret;
    }

    private static TemplateParser selectParser(CharBuffer buffer) throws URITemplateParseException {
        TemplateParser parser;
        char c = buffer.charAt(0);
        if (CharMatchers.LITERALS.matches(c)) {
            parser = new LiteralParser();
        } else if (BEGIN_EXPRESSION.matches(c)) {
            parser = new ExpressionParser();
        } else {
            throw new URITemplateParseException(BUNDLE.getMessage("parse.noParser"), buffer);
        }
        return parser;
    }
}

