/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.thirdparty.publicsuffix;

import java.util.Deque;
import znaishaded.com.google.common.annotations.GwtCompatible;
import znaishaded.com.google.common.base.Joiner;
import znaishaded.com.google.common.collect.ImmutableMap;
import znaishaded.com.google.common.collect.Queues;
import znaishaded.com.google.thirdparty.publicsuffix.PublicSuffixType;

@GwtCompatible
final class TrieParser {
    private static final Joiner PREFIX_JOINER = Joiner.on("");

    TrieParser() {
    }

    static ImmutableMap<String, PublicSuffixType> parseTrie(CharSequence encoded) {
        ImmutableMap.Builder<String, PublicSuffixType> builder = ImmutableMap.builder();
        int encodedLen = encoded.length();
        for (int idx = 0; idx < encodedLen; idx += TrieParser.doParseTrieToBuilder(Queues.newArrayDeque(), encoded, idx, builder)) {
        }
        return builder.build();
    }

    private static int doParseTrieToBuilder(Deque<CharSequence> stack2, CharSequence encoded, int start, ImmutableMap.Builder<String, PublicSuffixType> builder) {
        String domain;
        int idx;
        int encodedLen = encoded.length();
        char c = '\u0000';
        for (idx = start; idx < encodedLen && (c = encoded.charAt(idx)) != '&' && c != '?' && c != '!' && c != ':' && c != ','; ++idx) {
        }
        stack2.push(TrieParser.reverse(encoded.subSequence(start, idx)));
        if ((c == '!' || c == '?' || c == ':' || c == ',') && (domain = PREFIX_JOINER.join(stack2)).length() > 0) {
            builder.put(domain, PublicSuffixType.fromCode(c));
        }
        ++idx;
        if (c != '?' && c != ',') {
            while (idx < encodedLen) {
                if (encoded.charAt(idx += TrieParser.doParseTrieToBuilder(stack2, encoded, idx, builder)) != '?' && encoded.charAt(idx) != ',') continue;
                ++idx;
                break;
            }
        }
        stack2.pop();
        return idx - start;
    }

    private static CharSequence reverse(CharSequence s2) {
        return new StringBuilder(s2).reverse();
    }
}

