/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.util;

import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import znaishaded.com.fasterxml.jackson.databind.type.TypeFactory;
import znaishaded.io.swagger.models.properties.BaseIntegerProperty;
import znaishaded.io.swagger.models.properties.BinaryProperty;
import znaishaded.io.swagger.models.properties.BooleanProperty;
import znaishaded.io.swagger.models.properties.ByteArrayProperty;
import znaishaded.io.swagger.models.properties.DateProperty;
import znaishaded.io.swagger.models.properties.DateTimeProperty;
import znaishaded.io.swagger.models.properties.DecimalProperty;
import znaishaded.io.swagger.models.properties.DoubleProperty;
import znaishaded.io.swagger.models.properties.FileProperty;
import znaishaded.io.swagger.models.properties.FloatProperty;
import znaishaded.io.swagger.models.properties.IntegerProperty;
import znaishaded.io.swagger.models.properties.LongProperty;
import znaishaded.io.swagger.models.properties.ObjectProperty;
import znaishaded.io.swagger.models.properties.Property;
import znaishaded.io.swagger.models.properties.StringProperty;
import znaishaded.io.swagger.models.properties.UUIDProperty;

public enum PrimitiveType {
    BOOLEAN((Class)Boolean.class, "boolean"){

        @Override
        public BooleanProperty createProperty() {
            return new BooleanProperty();
        }
    }
    ,
    STRING((Class)String.class, "string"){

        @Override
        public StringProperty createProperty() {
            return new StringProperty();
        }
    }
    ,
    BYTE((Class)Byte.class, "byte"){

        @Override
        public ByteArrayProperty createProperty() {
            return new ByteArrayProperty();
        }
    }
    ,
    BINARY((Class)Byte.class, "binary"){

        @Override
        public BinaryProperty createProperty() {
            return new BinaryProperty();
        }
    }
    ,
    URI((Class)URI.class){

        @Override
        public StringProperty createProperty() {
            return new StringProperty(StringProperty.Format.URI);
        }
    }
    ,
    URL((Class)URL.class){

        @Override
        public StringProperty createProperty() {
            return new StringProperty(StringProperty.Format.URL);
        }
    }
    ,
    UUID((Class)UUID.class){

        @Override
        public UUIDProperty createProperty() {
            return new UUIDProperty();
        }
    }
    ,
    INT((Class)Integer.class, "integer"){

        @Override
        public IntegerProperty createProperty() {
            return new IntegerProperty();
        }
    }
    ,
    LONG((Class)Long.class, "long"){

        @Override
        public LongProperty createProperty() {
            return new LongProperty();
        }
    }
    ,
    FLOAT((Class)Float.class, "float"){

        @Override
        public FloatProperty createProperty() {
            return new FloatProperty();
        }
    }
    ,
    DOUBLE((Class)Double.class, "double"){

        @Override
        public DoubleProperty createProperty() {
            return new DoubleProperty();
        }
    }
    ,
    INTEGER((Class)BigInteger.class){

        @Override
        public BaseIntegerProperty createProperty() {
            return new BaseIntegerProperty();
        }
    }
    ,
    DECIMAL((Class)BigDecimal.class, "number"){

        @Override
        public DecimalProperty createProperty() {
            return new DecimalProperty();
        }
    }
    ,
    DATE((Class)DateStub.class, "date"){

        @Override
        public DateProperty createProperty() {
            return new DateProperty();
        }
    }
    ,
    DATE_TIME((Class)Date.class, "dateTime"){

        @Override
        public DateTimeProperty createProperty() {
            return new DateTimeProperty();
        }
    }
    ,
    FILE((Class)File.class, "file"){

        @Override
        public FileProperty createProperty() {
            return new FileProperty();
        }
    }
    ,
    OBJECT((Class)Object.class){

        @Override
        public ObjectProperty createProperty() {
            return new ObjectProperty();
        }
    };

    private static final Map<Class<?>, PrimitiveType> KEY_CLASSES;
    private static final Map<Class<?>, PrimitiveType> BASE_CLASSES;
    private static final Map<String, PrimitiveType> EXTERNAL_CLASSES;
    private static final Map<String, PrimitiveType> NAMES;
    private final Class<?> keyClass;
    private final String commonName;

    private PrimitiveType(Class<?> keyClass) {
        this(keyClass, null);
    }

    private PrimitiveType(Class<?> keyClass, String commonName) {
        this.keyClass = keyClass;
        this.commonName = commonName;
    }

    public static PrimitiveType fromType(Type type) {
        Class<?> raw = TypeFactory.defaultInstance().constructType(type).getRawClass();
        PrimitiveType key = KEY_CLASSES.get(raw);
        if (key != null) {
            return key;
        }
        PrimitiveType external = EXTERNAL_CLASSES.get(raw.getName());
        if (external != null) {
            return external;
        }
        for (Map.Entry<Class<?>, PrimitiveType> entry : BASE_CLASSES.entrySet()) {
            if (!entry.getKey().isAssignableFrom(raw)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static PrimitiveType fromName(String name) {
        if (name == null) {
            return null;
        }
        PrimitiveType fromName = NAMES.get(name);
        if (fromName == null) {
            fromName = EXTERNAL_CLASSES.get(name);
        }
        return fromName;
    }

    public static Property createProperty(Type type) {
        PrimitiveType item2 = PrimitiveType.fromType(type);
        return item2 == null ? null : item2.createProperty();
    }

    public static Property createProperty(String name) {
        PrimitiveType item2 = PrimitiveType.fromName(name);
        return item2 == null ? null : item2.createProperty();
    }

    public static String getCommonName(Type type) {
        PrimitiveType item2 = PrimitiveType.fromType(type);
        return item2 == null ? null : item2.getCommonName();
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public abstract Property createProperty();

    private static <K> void addKeys(Map<K, PrimitiveType> map, PrimitiveType type, K ... keys) {
        for (K key : keys) {
            map.put(key, type);
        }
    }

    static {
        HashMap keyClasses = new HashMap();
        PrimitiveType.addKeys(keyClasses, BOOLEAN, Boolean.class, Boolean.TYPE);
        PrimitiveType.addKeys(keyClasses, STRING, String.class, Character.class, Character.TYPE);
        PrimitiveType.addKeys(keyClasses, BYTE, Byte.class, Byte.TYPE);
        PrimitiveType.addKeys(keyClasses, URL, URL.class);
        PrimitiveType.addKeys(keyClasses, URI, URI.class);
        PrimitiveType.addKeys(keyClasses, UUID, UUID.class);
        PrimitiveType.addKeys(keyClasses, INT, Integer.class, Integer.TYPE, Short.class, Short.TYPE);
        PrimitiveType.addKeys(keyClasses, LONG, Long.class, Long.TYPE);
        PrimitiveType.addKeys(keyClasses, FLOAT, Float.class, Float.TYPE);
        PrimitiveType.addKeys(keyClasses, DOUBLE, Double.class, Double.TYPE);
        PrimitiveType.addKeys(keyClasses, INTEGER, BigInteger.class);
        PrimitiveType.addKeys(keyClasses, DECIMAL, BigDecimal.class);
        PrimitiveType.addKeys(keyClasses, DATE, DateStub.class);
        PrimitiveType.addKeys(keyClasses, DATE_TIME, Date.class);
        PrimitiveType.addKeys(keyClasses, FILE, File.class);
        PrimitiveType.addKeys(keyClasses, OBJECT, Object.class);
        KEY_CLASSES = Collections.unmodifiableMap(keyClasses);
        HashMap baseClasses = new HashMap();
        PrimitiveType.addKeys(baseClasses, DATE_TIME, Date.class, Calendar.class);
        BASE_CLASSES = Collections.unmodifiableMap(baseClasses);
        HashMap externalClasses = new HashMap();
        PrimitiveType.addKeys(externalClasses, DATE, "znaishaded.org.joda.time.LocalDate", "java.time.LocalDate");
        PrimitiveType.addKeys(externalClasses, DATE_TIME, "znaishaded.org.joda.time.DateTime", "znaishaded.org.joda.time.ReadableDateTime", "javax.xml.datatype.XMLGregorianCalendar", "java.time.LocalDateTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime");
        PrimitiveType.addKeys(externalClasses, LONG, "java.time.Instant");
        EXTERNAL_CLASSES = Collections.unmodifiableMap(externalClasses);
        TreeMap names = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (PrimitiveType item2 : PrimitiveType.values()) {
            String name = item2.getCommonName();
            if (name == null) continue;
            PrimitiveType.addKeys(names, item2, name);
        }
        PrimitiveType.addKeys(names, INT, "int");
        PrimitiveType.addKeys(names, OBJECT, "object");
        NAMES = Collections.unmodifiableMap(names);
    }

    private static class DateStub {
        private DateStub() {
        }
    }
}

