/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.util.List;
import java.util.Objects;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.web.MIMEHeader;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.ErrorHandler;
import znaishaded.io.vertx.ext.web.impl.Utils;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final boolean displayExceptionDetails;
    private final String errorTemplate;

    public ErrorHandlerImpl(String errorTemplateName, boolean displayExceptionDetails) {
        Objects.requireNonNull(errorTemplateName);
        this.displayExceptionDetails = displayExceptionDetails;
        this.errorTemplate = Utils.readResourceToBuffer(errorTemplateName).toString();
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerResponse response = context.response();
        Throwable failure = context.failure();
        int errorCode = context.statusCode();
        if (errorCode == -1) {
            errorCode = 500;
        }
        response.setStatusCode(errorCode);
        String errorMessage = response.getStatusMessage();
        if (this.displayExceptionDetails && (errorMessage = failure.getMessage()) != null) {
            errorMessage = errorMessage.replaceAll("\\r|\\n", " ");
            response.setStatusMessage(errorMessage);
        }
        this.answerWithError(context, errorCode, errorMessage);
    }

    private void answerWithError(RoutingContext context, int errorCode, String errorMessage) {
        if (!this.sendErrorResponseMIME(context, errorCode, errorMessage) && !this.sendErrorAcceptMIME(context, errorCode, errorMessage)) {
            this.sendError(context, "text/plain", errorCode, errorMessage);
        }
    }

    private boolean sendErrorResponseMIME(RoutingContext context, int errorCode, String errorMessage) {
        String mime = context.response().headers().get(HttpHeaders.CONTENT_TYPE);
        if (mime == null) {
            mime = context.getAcceptableContentType();
        }
        return mime != null && this.sendError(context, mime, errorCode, errorMessage);
    }

    private boolean sendErrorAcceptMIME(RoutingContext context, int errorCode, String errorMessage) {
        List<MIMEHeader> acceptableMimes = context.parsedHeaders().accept();
        for (MIMEHeader accept : acceptableMimes) {
            if (!this.sendError(context, accept.value(), errorCode, errorMessage)) continue;
            return true;
        }
        return false;
    }

    private boolean sendError(RoutingContext context, String mime, int errorCode, String errorMessage) {
        String title = "An unexpected error occurred";
        HttpServerResponse response = context.response();
        if (mime.startsWith("text/html")) {
            StringBuilder stack2 = new StringBuilder();
            if (context.failure() != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    stack2.append("<li>").append(elem).append("</li>");
                }
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
            response.end(this.errorTemplate.replace("{title}", "An unexpected error occurred").replace("{errorCode}", Integer.toString(errorCode)).replace("{errorMessage}", errorMessage).replace("{stackTrace}", stack2.toString()));
            return true;
        }
        if (mime.startsWith("application/json")) {
            JsonObject jsonError = new JsonObject();
            jsonError.put("error", new JsonObject().put("code", errorCode).put("message", errorMessage));
            if (context.failure() != null && this.displayExceptionDetails) {
                JsonArray stack3 = new JsonArray();
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    stack3.add(elem.toString());
                }
                jsonError.put("stack", stack3);
            }
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            response.end(jsonError.encode());
            return true;
        }
        if (mime.startsWith("text/plain")) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            StringBuilder sb = new StringBuilder();
            sb.append("Error ");
            sb.append(errorCode);
            sb.append(": ");
            sb.append(errorMessage);
            if (context.failure() != null && this.displayExceptionDetails) {
                for (StackTraceElement elem : context.failure().getStackTrace()) {
                    sb.append("\tat ").append(elem).append("\n");
                }
            }
            response.end(sb.toString());
            return true;
        }
        return false;
    }
}

