/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;

public class UrlBuilder {
    private static final String URL_PATTERN = "\\[\\[([%g][^%g]+[%g])?([\\w\\W]*?)\\]\\]";
    private final String topurl;
    private ModeUrl mode;

    public UrlBuilder(String topurl, ModeUrl mode) {
        this.topurl = topurl;
        this.mode = mode;
    }

    public Url getUrl(String s2) {
        Pattern2 p;
        if (this.mode == ModeUrl.STRICT) {
            p = MyPattern.cmpile("(?i)^\\[\\[([%g][^%g]+[%g])?([\\w\\W]*?)\\]\\]$");
        } else if (this.mode == ModeUrl.ANYWHERE) {
            p = MyPattern.cmpile("(?i).*\\[\\[([%g][^%g]+[%g])?([\\w\\W]*?)\\]\\].*");
        } else {
            throw new IllegalStateException();
        }
        Matcher2 m3 = p.matcher(StringUtils.trinNoTrace(s2));
        if (!m3.matches()) {
            return null;
        }
        String quotedPart = m3.group(1);
        String fullpp = m3.group(2).replaceAll("\\{scale=([0-9.]+)\\}", "\ue000scale=$1\ue001");
        int openBracket = this.openBracketBeforeSpace(fullpp);
        int closeBracket = openBracket == -1 ? -1 : fullpp.lastIndexOf(125);
        String full = fullpp.replace('\ue000', '{').replace('\ue001', '}');
        if (quotedPart == null) {
            if (openBracket != -1 && closeBracket != -1) {
                return new Url(this.withTopUrl(full.substring(0, openBracket)), full.substring(openBracket + 1, closeBracket), full.substring(closeBracket + 1).trim());
            }
            int firstSpace = full.indexOf(32);
            if (firstSpace == -1) {
                return new Url(full, null, null);
            }
            return new Url(this.withTopUrl(full.substring(0, firstSpace)), null, full.substring(firstSpace + 1).trim());
        }
        if (openBracket != -1 && closeBracket != -1) {
            return new Url(this.withTopUrl(quotedPart), full.substring(openBracket + 1, closeBracket), full.substring(closeBracket + 1).trim());
        }
        return new Url(this.withTopUrl(quotedPart), null, null);
    }

    private int openBracketBeforeSpace(String full) {
        int result = full.indexOf(123);
        return result;
    }

    private String withTopUrl(String url) {
        if (!url.startsWith("http:") && !url.startsWith("https:") && this.topurl != null) {
            return this.topurl + url;
        }
        return url;
    }

    public static String getRegexp() {
        return URL_PATTERN;
    }

    public static enum ModeUrl {
        STRICT,
        ANYWHERE;

    }
}

