/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.graphic.UGraphicDelegator;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChange;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class UGraphicInterceptorOneSwimlane
extends UGraphicDelegator {
    private final Swimlane swimlane;
    private final List<Swimlane> orderedList;

    public UGraphicInterceptorOneSwimlane(UGraphic ug, Swimlane swimlane, List<Swimlane> orderedList) {
        super(ug);
        this.swimlane = swimlane;
        this.orderedList = orderedList;
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof Ftile) {
            Ftile tile = (Ftile)shape;
            Set<Swimlane> swinlanes = tile.getSwimlanes();
            boolean contained = swinlanes.contains(this.swimlane);
            if (contained) {
                tile.drawU(this);
            }
        } else if (shape instanceof Connection) {
            boolean contained2;
            Connection connection = (Connection)shape;
            Ftile tile1 = connection.getFtile1();
            Ftile tile2 = connection.getFtile2();
            boolean contained1 = tile1 == null || tile1.getSwimlaneOut() == null || tile1.getSwimlaneOut() == this.swimlane;
            boolean bl = contained2 = tile2 == null || tile2.getSwimlaneIn() == null || tile2.getSwimlaneIn() == this.swimlane;
            if (contained1 && contained2) {
                connection.drawU(this);
            }
        } else {
            this.getUg().draw(shape);
        }
    }

    private void drawGoto() {
        UGraphic ugGoto = this.getUg().apply(HColorUtils.GREEN).apply(HColorUtils.GREEN.bg());
        ugGoto.draw(new ULine(100.0, 100.0));
    }

    @Override
    public UGraphic apply(UChange change) {
        return new UGraphicInterceptorOneSwimlane(this.getUg().apply(change), this.swimlane, this.orderedList);
    }

    public final Swimlane getSwimlane() {
        return this.swimlane;
    }

    public final List<Swimlane> getOrderedListOfAllSwimlanes() {
        return Collections.unmodifiableList(this.orderedList);
    }
}

