/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import znaishaded.net.sourceforge.plantuml.braille.BrailleGrid;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UEllipse;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class BrailleDrawer
implements UDrawable {
    private final BrailleGrid grid;
    private final double step = 9.0;
    private final double spotSize = 5.0;

    public BrailleDrawer(BrailleGrid grid) {
        this.grid = grid;
    }

    @Override
    public void drawU(UGraphic ug) {
        int x;
        ug = ug.apply(HColorSet.instance().getColorIfValid("#F0F0F0"));
        for (x = this.grid.getMinX(); x <= this.grid.getMaxX(); ++x) {
            ug.apply(UTranslate.dx((double)x * 9.0 + 5.0 + 1.0)).draw(ULine.vline((double)(this.grid.getMaxY() - this.grid.getMinY()) * 9.0));
        }
        for (int y = this.grid.getMinY(); y <= this.grid.getMaxY(); ++y) {
            ug.apply(UTranslate.dy((double)y * 9.0 + 5.0 + 1.0)).draw(ULine.hline((double)(this.grid.getMaxX() - this.grid.getMinX()) * 9.0));
        }
        ug = ug.apply(HColorUtils.BLACK).apply(HColorUtils.BLACK.bg());
        for (x = this.grid.getMinX(); x <= this.grid.getMaxX(); ++x) {
            for (int y = this.grid.getMinY(); y <= this.grid.getMaxY(); ++y) {
                if (!this.grid.getState(x, y)) continue;
                this.drawCircle(ug, x, y);
            }
        }
    }

    private void drawCircle(UGraphic ug, int x, int y) {
        double cx = (double)x * 9.0;
        double cy = (double)y * 9.0;
        ug.apply(new UTranslate(cx, cy)).draw(new UEllipse(5.0, 5.0));
    }
}

