/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandControl;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.core.Diagram;

public class CommandDecoratorMultine<D extends Diagram>
implements Command<D> {
    private final SingleLineCommand2<D> cmd;
    private final boolean removeEmptyColumn;
    private final int nbMaxLines;

    public CommandDecoratorMultine(SingleLineCommand2<D> cmd, int nbMaxLines) {
        this(cmd, false, nbMaxLines);
    }

    public CommandDecoratorMultine(SingleLineCommand2<D> cmd, boolean removeEmptyColumn, int nbMaxLines) {
        this.cmd = cmd;
        this.removeEmptyColumn = removeEmptyColumn;
        this.nbMaxLines = nbMaxLines;
    }

    @Override
    public CommandExecutionResult execute(D diagram, BlocLines lines) {
        if (this.removeEmptyColumn) {
            lines = lines.removeEmptyColumns();
        }
        lines = lines.toSingleLineWithHiddenNewLine();
        return this.cmd.execute(diagram, lines);
    }

    @Override
    public CommandControl isValid(BlocLines lines) {
        if (this.cmd.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        if (this.cmd.isForbidden((lines = lines.toSingleLineWithHiddenNewLine()).getFirst().getString())) {
            return CommandControl.NOT_OK;
        }
        CommandControl tmp = this.cmd.isValid(lines);
        if (tmp == CommandControl.OK_PARTIAL) {
            throw new IllegalStateException();
        }
        if (tmp == CommandControl.OK) {
            return tmp;
        }
        return CommandControl.OK_PARTIAL;
    }

    @Override
    public String[] getDescription() {
        return this.cmd.getDescription();
    }

    public int getNbMaxLines() {
        return this.nbMaxLines;
    }
}

