/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;

public class CommandCreoleUrl
implements Command {
    private final Pattern2 pattern;
    private final ISkinSimple skinParam;

    public static Command create(ISkinSimple skinParam) {
        return new CommandCreoleUrl(skinParam, "^(" + UrlBuilder.getRegexp() + ")");
    }

    private CommandCreoleUrl(ISkinSimple skinParam, String p) {
        this.pattern = MyPattern.cmpile(p);
        this.skinParam = skinParam;
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        UrlBuilder urlBuilder = new UrlBuilder(this.skinParam.getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
        Url url = urlBuilder.getUrl(m3.group(1));
        stripe.addUrl(url);
        return line.substring(m3.group(1).length());
    }
}

