/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.util.Map;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.cute.Cheese;
import znaishaded.net.sourceforge.plantuml.cute.Circle;
import znaishaded.net.sourceforge.plantuml.cute.CuteShape;
import znaishaded.net.sourceforge.plantuml.cute.Group;
import znaishaded.net.sourceforge.plantuml.cute.Positionned;
import znaishaded.net.sourceforge.plantuml.cute.PositionnedImpl;
import znaishaded.net.sourceforge.plantuml.cute.Rectangle;
import znaishaded.net.sourceforge.plantuml.cute.Stick;
import znaishaded.net.sourceforge.plantuml.cute.Triangle;
import znaishaded.net.sourceforge.plantuml.cute.VarArgs;

public class CuteShapeFactory {
    private final Map<String, Group> groups;

    public CuteShapeFactory(Map<String, Group> groups) {
        this.groups = groups;
    }

    public Positionned createCuteShapePositionned(String data) {
        VarArgs varArgs = new VarArgs(data);
        return new PositionnedImpl(this.createCuteShape(data), varArgs);
    }

    private CuteShape createCuteShape(String data) {
        data = StringUtils.trin(data.toLowerCase());
        VarArgs varArgs = new VarArgs(data);
        if (data.startsWith("circle ")) {
            return new Circle(varArgs);
        }
        if (data.startsWith("cheese ")) {
            return new Cheese(varArgs);
        }
        if (data.startsWith("stick ")) {
            return new Stick(varArgs);
        }
        if (data.startsWith("rectangle ") || data.startsWith("rect ")) {
            return new Rectangle(varArgs);
        }
        if (data.startsWith("triangle ")) {
            return new Triangle(varArgs);
        }
        String first = data.split(" ")[0];
        Group group = this.groups.get(first);
        if (group == null) {
            throw new IllegalArgumentException("Cannot find group " + first + " in " + this.groups.keySet());
        }
        return group;
    }
}

