/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.cute.Arc;
import znaishaded.net.sourceforge.plantuml.cute.CutePath;
import znaishaded.net.sourceforge.plantuml.cute.CuteShape;
import znaishaded.net.sourceforge.plantuml.cute.MyPoint2D;
import znaishaded.net.sourceforge.plantuml.cute.RotationZoom;
import znaishaded.net.sourceforge.plantuml.cute.VarArgs;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;

public class Rectangle
implements CuteShape {
    private final double width;
    private final double height;
    private final RotationZoom rotationZoom;
    private final double curvation;

    public Rectangle(VarArgs varArgs) {
        Point2D dim = varArgs.getAsPoint("dimension");
        this.width = dim.getX();
        this.height = dim.getY();
        this.rotationZoom = RotationZoom.none();
        this.curvation = varArgs.getAsDouble("curve", 0.0);
    }

    private Rectangle(double width, double height, RotationZoom rotationZoom, double curvation) {
        this.width = width;
        this.height = height;
        this.rotationZoom = rotationZoom;
        this.curvation = curvation;
    }

    @Override
    public void drawU(UGraphic ug) {
        CutePath cutePath = new CutePath();
        cutePath.add(new Arc(MyPoint2D.from(0.0, 0.0).withCurvation(this.curvation), MyPoint2D.from(this.width, 0.0).withCurvation(this.curvation)));
        cutePath.add(new Arc(MyPoint2D.from(this.width, 0.0).withCurvation(this.curvation), MyPoint2D.from(this.width, this.height).withCurvation(this.curvation)));
        cutePath.add(new Arc(MyPoint2D.from(this.width, this.height).withCurvation(this.curvation), MyPoint2D.from(0.0, this.height).withCurvation(this.curvation)));
        cutePath.add(new Arc(MyPoint2D.from(0.0, this.height).withCurvation(this.curvation), MyPoint2D.from(0.0, 0.0).withCurvation(this.curvation)));
        cutePath = cutePath.rotateZoom(this.rotationZoom);
        cutePath.drawU(ug);
    }

    public void drawUOld(UGraphic ug) {
        UPath path = new UPath();
        if (this.curvation == 0.0) {
            path.moveTo(this.rotationZoom.getPoint(0.0, 0.0));
            path.lineTo(this.rotationZoom.getPoint(this.width, 0.0));
            path.lineTo(this.rotationZoom.getPoint(this.width, this.height));
            path.lineTo(this.rotationZoom.getPoint(0.0, this.height));
            path.lineTo(this.rotationZoom.getPoint(0.0, 0.0));
        } else {
            path.moveTo(this.rotationZoom.getPoint(this.width, this.curvation));
            path.lineTo(this.rotationZoom.getPoint(this.width, this.height - this.curvation));
            path.arcTo(this.rotationZoom.getPoint(this.width - this.curvation, this.height), this.curvation, 0.0, 1.0);
            path.lineTo(this.rotationZoom.getPoint(this.curvation, this.height));
            path.arcTo(this.rotationZoom.getPoint(0.0, this.height - this.curvation), this.curvation, 0.0, 1.0);
            path.lineTo(this.rotationZoom.getPoint(0.0, this.curvation));
            path.arcTo(this.rotationZoom.getPoint(this.curvation, 0.0), this.curvation, 0.0, 1.0);
            path.lineTo(this.rotationZoom.getPoint(this.width - this.curvation, 0.0));
            path.arcTo(this.rotationZoom.getPoint(this.width, this.curvation), this.curvation, 0.0, 1.0);
        }
        path.closePath();
        ug.draw(path);
    }

    @Override
    public Rectangle rotateZoom(RotationZoom other) {
        return new Rectangle(this.width, this.height, this.rotationZoom.compose(other), this.curvation);
    }
}

