/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorNone;

public class BoxedCharacter
extends AbstractTextBlock
implements TextBlock {
    private final String c;
    private final UFont font;
    private final HColor innerCircle;
    private final HColor circle;
    private final HColor fontColor;
    private final double radius;

    public BoxedCharacter(char c, double size, UFont font, HColor innerCircle, HColor circle, HColor fontColor) {
        this.c = "" + c;
        this.font = font;
        this.innerCircle = innerCircle;
        this.circle = circle;
        this.fontColor = fontColor;
        this.radius = size;
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.circle != null) {
            ug = ug.apply(this.circle);
        }
        ug = this.innerCircle == null ? ug.apply(new HColorNone().bg()) : ug.apply(this.innerCircle.bg());
        ug.draw(new URectangle(2.0 * this.radius, 2.0 * this.radius));
        ug = ug.apply(this.fontColor);
        ug = ug.apply(new UTranslate(this.radius, this.radius));
        ug.draw(new UCenteredCharacter(this.c.charAt(0), this.font));
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }
}

