/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.awt.geom.GeneralPath;
import znaishaded.net.sourceforge.plantuml.geom.Box;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.Pointable;
import znaishaded.net.sourceforge.plantuml.geom.Polyline;

abstract class AbstractPolyline
implements Polyline {
    private final Pointable start;
    private final Pointable end;

    public AbstractPolyline(Pointable start, Pointable end) {
        this.start = start;
        this.end = end;
    }

    public final String toString() {
        return this.segments().toString();
    }

    @Override
    public final boolean doesTouch(Polyline other) {
        boolean result = this.doesTouchInternal(other);
        assert (result == ((AbstractPolyline)other).doesTouchInternal(this));
        return result;
    }

    private boolean doesTouchInternal(Polyline other) {
        for (int i = 0; i < this.nbSegments(); ++i) {
            LineSegmentInt seg1 = this.segments().get(i);
            for (int j = 0; j < other.nbSegments(); ++j) {
                boolean ignoreExtremities;
                LineSegmentInt seg2 = other.segments().get(j);
                boolean bl = ignoreExtremities = i == 0 || i == this.nbSegments() - 1 || j == 0 || j == other.nbSegments() - 1;
                if (!ignoreExtremities && seg1.doesIntersect(seg2)) {
                    return true;
                }
                if (!ignoreExtremities || !seg1.doesIntersectButNotSameExtremity(seg2)) continue;
                return true;
            }
        }
        return false;
    }

    public final LineSegmentInt getFirst() {
        return this.segments().get(0);
    }

    public final LineSegmentInt getLast() {
        return this.segments().get(this.nbSegments() - 1);
    }

    @Override
    public final double getLength() {
        double result = 0.0;
        for (LineSegmentInt seg : this.segments()) {
            result += seg.getLength();
        }
        return result;
    }

    public final Point2DInt clipStart(Box box) {
        assert (box.doesIntersect(this.segments().get(0)));
        Point2DInt[] inter = box.intersect(this.segments().get(0));
        assert (inter.length == 1);
        this.segments().set(0, new LineSegmentInt(inter[0].getXint(), inter[0].getYint(), this.segments().get(0).getP2().getXint(), this.segments().get(0).getP2().getYint()));
        return inter[0];
    }

    public final Point2DInt clipEnd(Box box) {
        int last = this.nbSegments() - 1;
        if (last == -1) {
            return null;
        }
        assert (box.doesIntersect(this.segments().get(last)));
        Point2DInt[] inter = box.intersect(this.segments().get(last));
        assert (inter.length == 1);
        this.segments().set(last, new LineSegmentInt(this.segments().get(last).getP1().getXint(), this.segments().get(last).getP1().getYint(), inter[0].getXint(), inter[0].getYint()));
        return inter[0];
    }

    public final boolean intersectBox(Box b) {
        for (LineSegmentInt seg : this.segments()) {
            if (!b.doesIntersect(seg)) continue;
            return true;
        }
        return false;
    }

    public final double getDistance(Box b) {
        double result = Double.MAX_VALUE;
        for (LineSegmentInt seg : this.segments()) {
            if (!b.doesIntersect(seg)) continue;
            result = Math.min(result, seg.getDistance(b.getCenterPoint()));
        }
        return result;
    }

    public final double getDistance(Polyline other) {
        double result = 0.0;
        for (LineSegmentInt seg1 : this.segments()) {
            for (LineSegmentInt seg2 : other.segments()) {
                result += seg1.getDistance(seg2);
            }
        }
        return result;
    }

    public final GeneralPath asGeneralPath() {
        GeneralPath generalPath = new GeneralPath();
        for (LineSegmentInt seg : this.segments()) {
            generalPath.append(seg, false);
        }
        return generalPath;
    }

    public final int getMinX() {
        int result = Integer.MAX_VALUE;
        for (LineSegmentInt seg : this.segments()) {
            result = Math.min(result, seg.getMinX());
        }
        return result;
    }

    public final int getMinY() {
        int result = Integer.MAX_VALUE;
        for (LineSegmentInt seg : this.segments()) {
            result = Math.min(result, seg.getMinY());
        }
        return result;
    }

    public final int getMaxX() {
        int result = Integer.MIN_VALUE;
        for (LineSegmentInt seg : this.segments()) {
            result = Math.max(result, seg.getMaxX());
        }
        return result;
    }

    public final int getMaxY() {
        int result = Integer.MIN_VALUE;
        for (LineSegmentInt seg : this.segments()) {
            result = Math.max(result, seg.getMaxY());
        }
        return result;
    }

    public final Pointable getStart() {
        return this.start;
    }

    public final Pointable getEnd() {
        return this.end;
    }
}

