/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.Pointable;
import znaishaded.net.sourceforge.plantuml.geom.XMoveable;

public class Box
implements XMoveable,
Pointable {
    private int x;
    private int y;
    private final int width;
    private final int height;

    public Box(int x, int y, int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public String toString() {
        return "Box [" + this.x + "," + this.y + "] " + this.width + "," + this.height;
    }

    public Point2DInt[] getCorners() {
        Point2DInt p1 = new Point2DInt(this.getX(), this.getY());
        Point2DInt p2 = new Point2DInt(this.getX() + this.getWidth(), this.getY());
        Point2DInt p3 = new Point2DInt(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        Point2DInt p4 = new Point2DInt(this.getX(), this.getY() + this.getHeight());
        return new Point2DInt[]{p1, p2, p3, p4};
    }

    public Point2DInt[] getCornersOfOneSide(LineSegmentInt seg, int sgn) {
        Point2DInt[] corners = this.getCorners();
        double sgn0 = seg.side(corners[0]);
        double sgn1 = seg.side(corners[1]);
        double sgn2 = seg.side(corners[2]);
        double sgn3 = seg.side(corners[3]);
        int nb = 0;
        if (Math.signum(sgn0) == (double)sgn) {
            ++nb;
        }
        if (Math.signum(sgn1) == (double)sgn) {
            ++nb;
        }
        if (Math.signum(sgn2) == (double)sgn) {
            ++nb;
        }
        if (Math.signum(sgn3) == (double)sgn) {
            ++nb;
        }
        Point2DInt[] result = new Point2DInt[nb];
        int i = 0;
        if (Math.signum(sgn0) == (double)sgn) {
            result[i++] = corners[0];
        }
        if (Math.signum(sgn1) == (double)sgn) {
            result[i++] = corners[1];
        }
        if (Math.signum(sgn2) == (double)sgn) {
            result[i++] = corners[2];
        }
        if (Math.signum(sgn3) == (double)sgn) {
            result[i++] = corners[3];
        }
        assert (nb == i);
        return result;
    }

    public boolean doesIntersect(LineSegmentInt seg) {
        return this.intersect(seg).length > 0;
    }

    public Point2DInt[] intersect(LineSegmentInt seg) {
        if (seg.side(this) != 0.0) {
            return new Point2DInt[0];
        }
        Point2DInt[] corners = this.getCorners();
        LineSegmentInt seg1 = new LineSegmentInt(corners[0], corners[1]);
        LineSegmentInt seg2 = new LineSegmentInt(corners[1], corners[2]);
        LineSegmentInt seg3 = new LineSegmentInt(corners[2], corners[3]);
        LineSegmentInt seg4 = new LineSegmentInt(corners[3], corners[0]);
        Point2DInt i1 = seg.getSegIntersection(seg1);
        Point2DInt i2 = seg.getSegIntersection(seg2);
        Point2DInt i3 = seg.getSegIntersection(seg3);
        Point2DInt i4 = seg.getSegIntersection(seg4);
        if (i2 != null && i2.equals(i1)) {
            i2 = null;
        }
        if (i3 != null && (i3.equals(i1) || i3.equals(i2))) {
            i3 = null;
        }
        if (i4 != null && (i4.equals(i1) || i4.equals(i2) || i4.equals(i3))) {
            i4 = null;
        }
        int nb = this.countNotNull(i1, i2, i3, i4);
        assert (nb >= 0 && nb <= 3) : nb;
        int i = 0;
        Point2DInt[] result = new Point2DInt[nb];
        if (i1 != null) {
            result[i++] = i1;
        }
        if (i2 != null) {
            result[i++] = i2;
        }
        if (i3 != null) {
            result[i++] = i3;
        }
        if (i4 != null) {
            result[i++] = i4;
        }
        assert (i == nb);
        assert (this.getCornersOfOneSide(seg, 0).length + this.getCornersOfOneSide(seg, 1).length + this.getCornersOfOneSide(seg, -1).length == 4);
        return result;
    }

    private int countNotNull(Point2DInt i1, Point2DInt i2, Point2DInt i3, Point2DInt i4) {
        int n = 0;
        if (i1 != null) {
            ++n;
        }
        if (i2 != null) {
            ++n;
        }
        if (i3 != null) {
            ++n;
        }
        if (i4 != null) {
            ++n;
        }
        return n;
    }

    public Box outerBox(int margin) {
        return new Box(this.x - margin, this.y - margin, this.width + 2 * margin, this.height + 2 * margin);
    }

    public Point2DInt getCenterPoint() {
        return new Point2DInt(this.x + this.width / 2, this.y + this.height / 2);
    }

    @Override
    public void moveX(int delta) {
        this.x += delta;
    }

    public boolean intersectBox(Box other) {
        return other.x + other.width > this.x && other.y + other.height > this.y && other.x < this.x + this.width && other.y < this.y + this.height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public int getMinX() {
        return this.x;
    }

    public int getMinY() {
        return this.y;
    }

    public int getMaxX() {
        return this.x + this.width;
    }

    public int getMaxY() {
        return this.y + this.height;
    }

    public int getCenterX() {
        return this.x + this.width / 2;
    }

    public int getCenterY() {
        return this.y + this.height / 2;
    }

    @Override
    public Point2DInt getPosition() {
        return this.getCenterPoint();
    }
}

