/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.geom.AbstractFigure;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;

public class ClosedArea
extends AbstractFigure {
    private final List<Point2DInt> points = new ArrayList<Point2DInt>();
    private final List<LineSegmentInt> segmentsList = new ArrayList<LineSegmentInt>();
    private int minY = Integer.MAX_VALUE;
    private int minX = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;

    public ClosedArea() {
        assert (this.isConsistent());
    }

    @Override
    public String toString() {
        return this.points.toString();
    }

    public boolean contains(Point2DInt point) {
        return this.contains(point.getXint(), point.getYint());
    }

    /*
     * Unable to fully structure code
     */
    private boolean contains(int x, int y) {
        if (this.points.size() <= 2) {
            return false;
        }
        if (x > this.maxX) {
            return false;
        }
        if (x < this.minX) {
            return false;
        }
        if (y > this.maxY) {
            return false;
        }
        if (y < this.minY) {
            return false;
        }
        if (this.isOnFrontier(new Point2DInt(x, y))) {
            return true;
        }
        hits = 0;
        lastx = this.getLastPoint().getXint();
        lasty = this.getLastPoint().getYint();
        for (i = 0; i < this.points.size(); ++i) {
            block13: {
                block16: {
                    block17: {
                        block15: {
                            block14: {
                                curx = this.points.get(i).getXint();
                                cury = this.points.get(i).getYint();
                                if (cury == lasty) break block13;
                                if (curx >= lastx) break block14;
                                if (x >= lastx) break block13;
                                leftx = curx;
                                break block15;
                            }
                            if (x >= curx) break block13;
                            leftx = lastx;
                        }
                        if (cury >= lasty) break block16;
                        if (y < cury || y >= lasty) break block13;
                        if (x >= leftx) break block17;
                        ++hits;
                        break block13;
                    }
                    test1 = x - curx;
                    test2 = y - cury;
                    ** GOTO lbl44
                }
                if (y < lasty || y >= cury) break block13;
                if (x < leftx) {
                    ++hits;
                } else {
                    test1 = x - lastx;
                    test2 = y - lasty;
lbl44:
                    // 2 sources

                    if (test1 < test2 / (double)(lasty - cury) * (double)(lastx - curx)) {
                        ++hits;
                    }
                }
            }
            lastx = curx;
            lasty = cury;
        }
        return (hits & true) != false;
    }

    private boolean isConsistent() {
        assert (this.getSegments().size() == this.segmentsList.size());
        assert (this.getSegments().equals(new HashSet<LineSegmentInt>(this.segmentsList)));
        if (this.getSegments().size() > 0) assert (this.getSegments().size() + 1 == this.points.size()) : "points=" + this.points + " getSegment()=" + this.getSegments();
        for (int i = 0; i < this.segmentsList.size(); ++i) {
            LineSegmentInt seg = this.segmentsList.get(i);
            if (seg.sameExtremities(new LineSegmentInt(this.points.get(i), this.points.get(i + 1)))) continue;
            return false;
        }
        return true;
    }

    public boolean isOnFrontier(Point2DInt point) {
        for (LineSegmentInt seg : this.segmentsList) {
            if (!seg.containsPoint(point)) continue;
            return true;
        }
        return false;
    }

    public boolean isClosed() {
        if (this.getSegments().size() < 3) {
            return false;
        }
        return this.getFirstSegment().atLeastOneCommonExtremities(this.getLastSegment());
    }

    ClosedArea append(LineSegmentInt other) {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        if (this.getSegments().contains(other)) {
            throw new IllegalArgumentException();
        }
        ClosedArea result = new ClosedArea();
        for (LineSegmentInt seg : this.segmentsList) {
            result.addSegment(seg);
        }
        if (result.getSegments().size() > 0 && !result.getLastSegment().atLeastOneCommonExtremities(other)) {
            throw new IllegalArgumentException();
        }
        if (this.points.contains(other.getP1()) && this.points.contains(other.getP2()) && !other.getP1().equals(this.getFirstPoint()) && !other.getP2().equals(this.getFirstPoint())) {
            return null;
        }
        result.addSegment(other);
        assert (result.isConsistent());
        return result;
    }

    @Override
    public void addSegment(LineSegmentInt seg) {
        super.addSegment(seg);
        this.minY = Math.min(this.minY, seg.getMinY());
        this.maxY = Math.max(this.maxY, seg.getMaxY());
        this.minX = Math.min(this.minX, seg.getMinX());
        this.maxX = Math.max(this.maxX, seg.getMaxX());
        this.segmentsList.add(seg);
        if (this.points.size() == 0) {
            assert (this.getSegments().size() == 1);
            this.points.add(seg.getP1());
            this.points.add(seg.getP2());
        } else if (this.points.size() == 2) {
            assert (this.segmentsList.size() == 2);
            LineSegmentInt seg0 = this.segmentsList.get(0);
            LineSegmentInt seg1 = this.segmentsList.get(1);
            this.points.clear();
            Point2DInt common = seg0.getCommonExtremities(seg1);
            if (common == null) {
                throw new IllegalArgumentException();
            }
            assert (common.equals(seg1.getCommonExtremities(seg0)));
            this.points.add(seg0.getOtherExtremity(common));
            this.points.add(common);
            this.points.add(seg1.getOtherExtremity(common));
        } else {
            Point2DInt lastPoint = this.getLastPoint();
            this.points.add(seg.getOtherExtremity(lastPoint));
        }
        assert (this.isConsistent());
    }

    private Point2DInt getLastPoint() {
        return this.points.get(this.points.size() - 1);
    }

    private Point2DInt getFirstPoint() {
        return this.points.get(0);
    }

    public LineSegmentInt getLastSegment() {
        return this.segmentsList.get(this.segmentsList.size() - 1);
    }

    private LineSegmentInt getFirstSegment() {
        return this.segmentsList.get(0);
    }

    public Point2DInt getFreePoint() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
        return this.getLastPoint();
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public boolean contains(ClosedArea other) {
        if (!this.isClosed()) {
            throw new IllegalStateException();
        }
        for (Point2DInt point : other.points) {
            if (this.contains(point)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean arePointsConnectable(Point2DInt p1, Point2DInt p2) {
        boolean pos2;
        if (this.isOnFrontier(p1) || this.isOnFrontier(p2)) {
            return true;
        }
        boolean pos1 = this.contains(p1);
        return pos1 == (pos2 = this.contains(p2));
    }
}

