/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.geom.AbstractPolyline;
import znaishaded.net.sourceforge.plantuml.geom.InflationTransform;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.Pointable;
import znaishaded.net.sourceforge.plantuml.geom.Polyline;

public class PolylineImpl
extends AbstractPolyline
implements Polyline {
    private final List<Point2DInt> intermediates = new ArrayList<Point2DInt>();

    public PolylineImpl(Pointable start, Pointable end) {
        super(start, end);
    }

    @Override
    public int nbSegments() {
        return this.intermediates.size() + 1;
    }

    @Override
    public List<LineSegmentInt> segments() {
        ArrayList<LineSegmentInt> result = new ArrayList<LineSegmentInt>();
        Point2DInt cur = this.getStart().getPosition();
        for (Point2DInt intermediate : this.intermediates) {
            result.add(new LineSegmentInt(cur, intermediate));
            cur = intermediate;
        }
        result.add(new LineSegmentInt(cur, this.getEnd().getPosition()));
        return Collections.unmodifiableList(result);
    }

    public void addIntermediate(Point2DInt intermediate) {
        assert (!this.intermediates.contains(intermediate));
        this.intermediates.add(intermediate);
    }

    public void inflate(InflationTransform transform) {
        List<LineSegmentInt> segments = transform.inflate(this.segments());
        this.intermediates.clear();
        for (int i = 1; i < segments.size() - 1; ++i) {
            this.addIntermediate(segments.get(i).getP1());
        }
    }

    public final Collection<Point2DInt> getIntermediates() {
        return Collections.unmodifiableCollection(this.intermediates);
    }
}

