/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom.kinetic;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.Frame;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.MoveObserver;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.Path;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.Quadrant;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.QuadrantMapper;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.VectorForce;

public class World
implements MoveObserver {
    private final List<Path> paths = new ArrayList<Path>();
    private final Map<Point2DCharge, Path> pathOfPoints = new HashMap<Point2DCharge, Path>();
    private final List<Frame> frames = new ArrayList<Frame>();
    private QuadrantMapper quadrantMapper;

    public void addFrame(Frame frame) {
        this.frames.add(frame);
    }

    public void addPath(Path path) {
        this.paths.add(path);
    }

    public VectorForce getElectricForce(Point2DCharge point) {
        VectorForce result = new VectorForce(0.0, 0.0);
        Quadrant quadrant = new Quadrant(point);
        for (Quadrant q : quadrant.neighbourhood()) {
            for (Point2DCharge pc2 : this.quadrantMapper.getAllPoints(q)) {
                Path path = this.pathOfPoints.get(pc2);
                if (path.containsPoint2DCharge(point)) continue;
                result = result.plus(World.getElectricForce(point, pc2));
            }
        }
        return result;
    }

    private VectorForce getElectricForceSlow(Point2DCharge point) {
        VectorForce result = new VectorForce(0.0, 0.0);
        for (Path path : this.paths) {
            if (path.containsPoint2DCharge(point)) continue;
            for (Point2DCharge pc2 : path.getPoints()) {
                result = result.plus(World.getElectricForce(point, pc2));
            }
        }
        return result;
    }

    private static VectorForce getElectricForce(Point2DCharge onThis, Point2DCharge byThis) {
        double dist = onThis.distance(byThis);
        if (dist == 0.0) {
            return new VectorForce(0.0, 0.0);
        }
        VectorForce result = new VectorForce(byThis.getX() - onThis.getX(), byThis.getY() - onThis.getY());
        double v = 100.0 * onThis.getCharge() * byThis.getCharge() / dist / dist;
        return result.normaliseTo(v);
    }

    private static VectorForce getAtomicForce(Point2DCharge onThis, Point2DCharge byThis) {
        double dist = onThis.distance(byThis);
        if (dist == 0.0) {
            return new VectorForce(0.0, 0.0);
        }
        VectorForce result = new VectorForce(byThis.getX() - onThis.getX(), byThis.getY() - onThis.getY());
        double v = 1000.0 / dist / dist / dist;
        if (v > 5.0) {
            v = 5.0;
        }
        return result.normaliseTo(v);
    }

    Map<Point2DCharge, VectorForce> getForces() {
        LinkedHashMap<Point2DCharge, VectorForce> result = new LinkedHashMap<Point2DCharge, VectorForce>();
        for (Path path : this.paths) {
            for (Point2DCharge pt : path.getPoints()) {
                VectorForce elastic = path.getElasticForce(pt);
                VectorForce elect = this.getElectricForce(pt);
                VectorForce force = elastic.plus(elect);
                for (Frame f : this.frames) {
                    Point2D inter = f.getFrontierPointViewBy(pt);
                    if (inter == null) continue;
                    Point2DCharge pchar = new Point2DCharge(inter, 1.0);
                    force = force.plus(World.getAtomicForce(pt, pchar));
                }
                result.put(pt, force);
            }
        }
        return result;
    }

    public double onePass() {
        double result = 0.0;
        Map<Point2DCharge, VectorForce> forces = this.getForces();
        for (Map.Entry<Point2DCharge, VectorForce> ent : forces.entrySet()) {
            VectorForce force = ent.getValue();
            result += force.getLength();
            ent.getKey().apply(force);
        }
        return result;
    }

    public final Collection<Path> getPaths() {
        return Collections.unmodifiableCollection(this.paths);
    }

    public void renderContinue() {
        this.quadrantMapper = new QuadrantMapper();
        this.pathOfPoints.clear();
        for (Path path : this.paths) {
            path.renderContinue();
        }
        for (Path path : this.paths) {
            for (Point2DCharge pt : path.getPoints()) {
                pt.setMoveObserver(this);
                this.quadrantMapper.addPoint(pt);
                this.pathOfPoints.put(pt, path);
            }
        }
    }

    @Override
    public void pointMoved(Point2DCharge point) {
        this.quadrantMapper.updatePoint(point);
    }
}

