/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.PolylineBreakeable;
import znaishaded.net.sourceforge.plantuml.geom.SpiderWeb;
import znaishaded.net.sourceforge.plantuml.graph.ALink;
import znaishaded.net.sourceforge.plantuml.graph.Board;

public class Galaxy4 {
    private final Board board;
    private final Map<ALink, PolylineBreakeable> lines = new LinkedHashMap<ALink, PolylineBreakeable>();
    private final SpiderWeb spiderWeb;

    public Galaxy4(Board board, int widthCell, int heightCell) {
        this.spiderWeb = new SpiderWeb(widthCell, heightCell);
        this.board = board;
    }

    public Point2DInt getMainPoint(int row, int col) {
        return this.spiderWeb.getMainPoint(row, col);
    }

    public PolylineBreakeable getPolyline(ALink link) {
        return this.lines.get(link);
    }

    public void addLink(ALink link) {
        int rowStart = link.getNode1().getRow();
        int rowEnd = link.getNode2().getRow();
        int colStart = this.board.getCol(link.getNode1());
        int colEnd = this.board.getCol(link.getNode2());
        PolylineBreakeable polyline = this.spiderWeb.addPolyline(rowStart, colStart, rowEnd, colEnd);
        Log.info("link=" + link + " polyline=" + polyline);
        if (polyline == null) {
            Log.info("PENDING " + link + " " + polyline);
        } else {
            this.lines.put(link, polyline);
        }
    }

    public final Board getBoard() {
        return this.board;
    }

    public final Map<ALink, PolylineBreakeable> getLines() {
        return Collections.unmodifiableMap(this.lines);
    }
}

