/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.graph2.GeomUtils;
import znaishaded.net.sourceforge.plantuml.graph2.IInflationTransform;
import znaishaded.net.sourceforge.plantuml.graph2.InflateData2;
import znaishaded.net.sourceforge.plantuml.graph2.Point2DComparatorDistance;

public class InflationTransform2
implements IInflationTransform {
    private final List<InflateData2> inflateX = new ArrayList<InflateData2>();
    private final List<InflateData2> inflateY = new ArrayList<InflateData2>();

    @Override
    public void addInflationX(double xpos, double inflation) {
        InflationTransform2.add(this.inflateX, xpos, inflation);
    }

    public String toString() {
        return "inflateX = " + this.inflateX + " inflateY = " + this.inflateY;
    }

    @Override
    public void addInflationY(double ypos, double inflation) {
        InflationTransform2.add(this.inflateY, ypos, inflation);
    }

    @Override
    public double getTotalInflationX() {
        return InflationTransform2.sumInflation(this.inflateX);
    }

    @Override
    public double getTotalInflationY() {
        return InflationTransform2.sumInflation(this.inflateY);
    }

    private static double sumInflation(List<InflateData2> list) {
        double result = 0.0;
        for (InflateData2 data : list) {
            result += data.getInflation();
        }
        return result;
    }

    private static void add(List<InflateData2> list, double ypos, double inflation) {
        ListIterator<InflateData2> it = list.listIterator();
        while (it.hasNext()) {
            InflateData2 cur = it.next();
            if (cur.getPos() != ypos) continue;
            it.set(new InflateData2(ypos, Math.max(inflation, cur.getInflation())));
            return;
        }
        list.add(new InflateData2(ypos, inflation));
        Collections.sort(list);
    }

    Collection<Point2D.Double> cutPoints(Line2D.Double original) {
        Point2D.Double inter;
        TreeSet<Point2D> result = new TreeSet<Point2D>(new Point2DComparatorDistance(original.getP1()));
        if (!GeomUtils.isHorizontal(original)) {
            for (InflateData2 x : this.inflateX) {
                Line2D.Double vertical = new Line2D.Double(x.getPos(), GeomUtils.getMinY(original), x.getPos(), GeomUtils.getMaxY(original));
                inter = GeomUtils.getSegIntersection(original, vertical);
                if (inter == null) continue;
                result.add(inter);
            }
        }
        if (!GeomUtils.isVertical(original)) {
            for (InflateData2 y : this.inflateY) {
                Line2D.Double horizontal = new Line2D.Double(GeomUtils.getMinX(original), y.getPos(), GeomUtils.getMaxX(original), y.getPos());
                inter = GeomUtils.getSegIntersection(original, horizontal);
                if (inter == null) continue;
                result.add(inter);
            }
        }
        return result;
    }

    Collection<Line2D.Double> cutSegments(Line2D.Double original) {
        ArrayList<Line2D.Double> result = new ArrayList<Line2D.Double>();
        Point2D.Double cur = (Point2D.Double)original.getP1();
        Collection<Point2D.Double> cutPoints = this.cutPoints(original);
        for (Point2D.Double inter : cutPoints) {
            if (cur.equals(inter)) continue;
            result.add(new Line2D.Double(cur, inter));
            cur = inter;
        }
        if (!cur.equals(original.getP2())) {
            result.add(new Line2D.Double(cur, original.getP2()));
        }
        return result;
    }

    Collection<Line2D.Double> cutSegments(Collection<Line2D.Double> segments) {
        ArrayList<Line2D.Double> result = new ArrayList<Line2D.Double>();
        for (Line2D.Double seg : segments) {
            result.addAll(this.cutSegments(seg));
        }
        return result;
    }

    @Override
    public Point2D inflatePoint2D(Point2D point) {
        return this.getAffineTransformAt(point).transform(point, null);
    }

    AffineTransform getAffineTransformAt(Point2D point) {
        double deltaX = 0.0;
        for (InflateData2 x : this.inflateX) {
            deltaX += x.inflateAt(point.getX());
        }
        double deltaY = 0.0;
        for (InflateData2 y : this.inflateY) {
            deltaY += y.inflateAt(point.getY());
        }
        return AffineTransform.getTranslateInstance(deltaX, deltaY);
    }

    List<Line2D.Double> inflateSegmentCollection(Collection<Line2D.Double> segments) {
        ArrayList<Line2D.Double> result = new ArrayList<Line2D.Double>();
        for (Line2D.Double seg : segments) {
            AffineTransform at = this.getAffineTransformAt(new Point2D.Double((seg.x1 + seg.x2) / 2.0, (seg.y1 + seg.y2) / 2.0));
            result.add(new Line2D.Double(at.transform(seg.getP1(), null), at.transform(seg.getP2(), null)));
        }
        return result;
    }

    @Override
    public List<Line2D.Double> inflate(Collection<Line2D.Double> segments) {
        Collection<Line2D.Double> cutSegments = this.cutSegments(segments);
        Line2D.Double last = null;
        List<Line2D.Double> inflated = this.inflateSegmentCollection(cutSegments);
        ArrayList<Line2D.Double> result = new ArrayList<Line2D.Double>();
        for (Line2D.Double seg : inflated) {
            if (last != null && !last.getP2().equals(seg.getP1())) {
                result.add(new Line2D.Double(last.getP2(), seg.getP1()));
            }
            result.add(seg);
            last = seg;
        }
        return result;
    }
}

