/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.graph2.Measurer;
import znaishaded.net.sourceforge.plantuml.graph2.SortedList;

public class SortedListImpl<V>
implements SortedList<V> {
    private final Measurer<V> measurer;
    private final List<V> all = new ArrayList<V>();
    private final Comparator<V> comparator;

    public SortedListImpl(Measurer<V> m3) {
        this.measurer = m3;
        this.comparator = new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                int v1 = SortedListImpl.this.measurer.getMeasure(o1);
                int v2 = SortedListImpl.this.measurer.getMeasure(o2);
                return v1 - v2;
            }
        };
    }

    @Override
    public void add(V data) {
        int pos = Collections.binarySearch(this.all, data, this.comparator);
        if (pos >= 0) {
            this.all.add(pos, data);
        } else {
            this.all.add(-pos - 1, data);
        }
        assert (this.isSorted());
    }

    private int getPos(int v, boolean plus) {
        final NullableAndEvenMeasurer<V> m3 = new NullableAndEvenMeasurer<V>(this.measurer, v, plus);
        Comparator myComp = new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                int v1 = m3.getMeasure(o1);
                int v2 = m3.getMeasure(o2);
                return v1 - v2;
            }
        };
        int pos = Collections.binarySearch(this.all, null, myComp);
        assert (pos < 0);
        return -pos - 1;
    }

    @Override
    public List<V> lesserOrEquals(int v) {
        return this.all.subList(0, this.getPos(v, true));
    }

    @Override
    public List<V> biggerOrEquals(int v) {
        return this.all.subList(this.getPos(v, false), this.all.size());
    }

    private boolean isSorted() {
        for (int i = 0; i < this.all.size() - 1; ++i) {
            int v2;
            int v1 = this.measurer.getMeasure(this.all.get(i));
            if (v1 <= (v2 = this.measurer.getMeasure(this.all.get(i + 1)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<V> iterator() {
        return this.all.iterator();
    }

    static class NullableAndEvenMeasurer<V>
    implements Measurer<V> {
        private final Measurer<V> wrapped;
        private final int valueForNull;

        NullableAndEvenMeasurer(Measurer<V> wrapped, int valueForNull, boolean plus) {
            this.wrapped = wrapped;
            this.valueForNull = plus ? valueForNull * 2 + 1 : valueForNull * 2 - 1;
        }

        @Override
        public int getMeasure(V data) {
            if (data == null) {
                return this.valueForNull;
            }
            return this.wrapped.getMeasure(data) * 2;
        }
    }
}

