/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public enum HorizontalAlignment {
    LEFT,
    CENTER,
    RIGHT;


    public static HorizontalAlignment fromString(String s2) {
        if (LEFT.name().equalsIgnoreCase(s2)) {
            return LEFT;
        }
        if (CENTER.name().equalsIgnoreCase(s2)) {
            return CENTER;
        }
        if (RIGHT.name().equalsIgnoreCase(s2)) {
            return RIGHT;
        }
        return null;
    }

    public static HorizontalAlignment fromString(String s2, HorizontalAlignment defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException();
        }
        if (s2 == null) {
            return defaultValue;
        }
        HorizontalAlignment result = HorizontalAlignment.fromString(s2 = StringUtils.goUpperCase(s2));
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getGraphVizValue() {
        return this.toString().substring(0, 1).toLowerCase();
    }

    public void draw(UGraphic ug, TextBlock tb, double padding, Dimension2D dimTotal) {
        if (this == LEFT) {
            tb.drawU(ug.apply(new UTranslate(padding, padding)));
        } else if (this == RIGHT) {
            Dimension2D dimTb = tb.calculateDimension(ug.getStringBounder());
            tb.drawU(ug.apply(new UTranslate(dimTotal.getWidth() - dimTb.getWidth() - padding, padding)));
        } else if (this == CENTER) {
            Dimension2D dimTb = tb.calculateDimension(ug.getStringBounder());
            tb.drawU(ug.apply(new UTranslate((dimTotal.getWidth() - dimTb.getWidth()) / 2.0, padding)));
        }
    }
}

