/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;

public class SvgAttributes {
    private final Map<String, String> attributes = new TreeMap<String, String>();

    public SvgAttributes() {
    }

    private SvgAttributes(SvgAttributes other) {
        this.attributes.putAll(other.attributes);
    }

    public SvgAttributes(String args) {
        Pattern2 p = MyPattern.cmpile("(\\w+)\\s*=\\s*([%g][^%g]*[%g]|(?:\\w+))");
        Matcher2 m3 = p.matcher(args);
        while (m3.find()) {
            this.attributes.put(m3.group(1), StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m3.group(2)));
        }
    }

    public Map<String, String> attributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public SvgAttributes add(String key, String value) {
        SvgAttributes result = new SvgAttributes(this);
        result.attributes.put(key, value);
        return result;
    }

    public SvgAttributes add(SvgAttributes toBeAdded) {
        SvgAttributes result = new SvgAttributes(this);
        result.attributes.putAll(toBeAdded.attributes);
        return result;
    }
}

