/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.jungle;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.jungle.GNode;
import znaishaded.net.sourceforge.plantuml.jungle.GTileNode;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class Needle
implements UDrawable {
    private final double length;
    private final Display display;
    private final double degreePosition;
    private final double degreeOperture;

    private Needle(Display display, double length, double degreePosition, double degreeOperture) {
        this.display = display;
        this.degreePosition = degreePosition;
        this.degreeOperture = degreeOperture;
        this.length = length;
    }

    @Override
    public void drawU(UGraphic ug) {
        GTileNode.getTextBlock(this.display);
        ug.draw(this.getLine());
        ug = ug.apply(this.getTranslate(this.length));
        GTileNode.getTextBlock(this.display).drawU(ug);
    }

    private ULine getLine() {
        UTranslate translate = this.getTranslate(this.length);
        return new ULine(translate.getDx(), translate.getDy());
    }

    public UTranslate getTranslate(double dist) {
        double angle = this.degreePosition * Math.PI / 180.0;
        double dx = dist * Math.cos(angle);
        double dy = dist * Math.sin(angle);
        return new UTranslate(dx, dy);
    }

    public UDrawable addChildren(final List<GNode> children) {
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                Needle.this.drawU(ug);
                if (children.size() == 0) {
                    return;
                }
                ug = ug.apply(Needle.this.getTranslate(Needle.this.length / 2.0));
                UDrawable child1 = Needle.getNeedle((GNode)children.get(0), Needle.this.length / 2.0, Needle.this.degreePosition + Needle.this.degreeOperture, Needle.this.degreeOperture / 2.0);
                child1.drawU(ug);
                if (children.size() == 1) {
                    return;
                }
                UDrawable child2 = Needle.getNeedle((GNode)children.get(1), Needle.this.length / 2.0, Needle.this.degreePosition - Needle.this.degreeOperture, Needle.this.degreeOperture / 2.0);
                child2.drawU(ug);
            }
        };
    }

    public static UDrawable getNeedle(GNode root, double length, double degree, double degreeOperture) {
        Needle needle0 = new Needle(root.getDisplay(), length, degree, degreeOperture);
        final UDrawable n1 = needle0.addChildren(root.getChildren());
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                ug = ug.apply(HColorUtils.BLACK);
                n1.drawU(ug);
            }
        };
    }
}

