/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.logo;

import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.logo.LogoScanner;
import znaishaded.net.sourceforge.plantuml.logo.LogoToken;
import znaishaded.net.sourceforge.plantuml.logo.TurtleGraphicsPane;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class TinyJavaLogo {
    private final LogoScanner scanner = new LogoScanner();
    private final TurtleGraphicsPane turtleGraphicsPane;
    private final Map<String, String> dictionary = new HashMap<String, String>();
    private HColor penColor;

    public TinyJavaLogo(TurtleGraphicsPane turtleGraphicsPane) {
        this.turtleGraphicsPane = turtleGraphicsPane;
    }

    private void message(String messageText) {
    }

    private void error(String messageText) {
        this.turtleGraphicsPane.message("Error: " + messageText);
    }

    private void parseCommandBlock(int nestLevel) {
        LogoToken token = this.scanner.getToken();
        block17: while (token.kind != 256 && token.kind != 257) {
            switch (token.kind) {
                case 260: {
                    token = this.scanner.getToken();
                    if (token.kind == 259 || token.kind == 270) {
                        this.turtleGraphicsPane.forward(token.value);
                        token = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("FORWARD requires distance");
                    return;
                }
                case 261: {
                    token = this.scanner.getToken();
                    if (token.kind == 259 || token.kind == 270) {
                        this.turtleGraphicsPane.back(token.value);
                        token = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("BACK requires distance");
                    return;
                }
                case 262: {
                    token = this.scanner.getToken();
                    if (token.kind == 259 || token.kind == 270) {
                        this.turtleGraphicsPane.left(token.value);
                        token = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("LEFT requires turn angle");
                    return;
                }
                case 263: {
                    token = this.scanner.getToken();
                    if (token.kind == 259 || token.kind == 270) {
                        this.turtleGraphicsPane.right(token.value);
                        token = this.scanner.getToken();
                        continue block17;
                    }
                    this.error("RIGHT requires turn angle");
                    return;
                }
                case 264: {
                    this.turtleGraphicsPane.penUp();
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 265: {
                    this.turtleGraphicsPane.penDown();
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 266: {
                    this.turtleGraphicsPane.hideTurtle();
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 267: {
                    this.turtleGraphicsPane.showTurtle();
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 268: {
                    this.turtleGraphicsPane.clearScreen();
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 269: {
                    token = this.scanner.getToken();
                    if (token.kind != 270) {
                        this.error("REPEAT requires positive integer count");
                        return;
                    }
                    int count = token.intValue;
                    token = this.scanner.getToken();
                    if (token.kind != 91) {
                        this.error("REPEAT requires block in []");
                        return;
                    }
                    int blockStart = this.scanner.getPosition();
                    while (count-- > 0) {
                        this.scanner.setPosition(blockStart);
                        this.parseCommandBlock(nestLevel + 1);
                    }
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 271: {
                    token = this.scanner.getToken();
                    if (token.kind != 258) {
                        this.error("TO requires name for new definition");
                        return;
                    }
                    String commandName = token.lexeme;
                    if (this.dictionary.get(commandName) == null) {
                        this.message("Defining new command " + commandName);
                    } else {
                        this.message("Redefining command " + commandName);
                    }
                    String code = this.scanner.getRestAsString();
                    this.dictionary.put(commandName, code);
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 258: {
                    String commandName = token.lexeme;
                    String code = this.dictionary.get(commandName);
                    if (code == null) {
                        this.error("Undefined command " + commandName);
                        return;
                    }
                    String savedCommand = this.scanner.getSourceString();
                    int savedPosition = this.scanner.getPosition();
                    this.scanner.setSourceString(code);
                    this.parseCommandBlock(0);
                    this.scanner.setSourceString(savedCommand);
                    this.scanner.setPosition(savedPosition);
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 272: {
                    token = this.scanner.getToken();
                    HColor newPenColor = HColorSet.instance().getColorIfValid(token.lexeme);
                    if (newPenColor == null) {
                        this.error("Unrecognized color name");
                        return;
                    }
                    this.penColor = newPenColor;
                    this.turtleGraphicsPane.setPenColor(this.penColor);
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 91: {
                    token = this.scanner.getToken();
                    continue block17;
                }
                case 93: {
                    if (nestLevel == 0) {
                        this.error("] without matching [");
                        token = this.scanner.getToken();
                        return;
                    }
                    return;
                }
            }
            this.error("Unrecognized symbol in input");
            return;
        }
    }

    public void doCommandLine(String commandLine) {
        this.message(commandLine);
        this.scanner.setSourceString(commandLine);
        this.parseCommandBlock(0);
    }
}

