/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.postit;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.postit.AreaLayoutFixedWidth;
import znaishaded.net.sourceforge.plantuml.postit.Elastic;
import znaishaded.net.sourceforge.plantuml.postit.PostIt;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Area
implements Elastic {
    private final String title;
    private final char id;
    private Dimension2D minimumDimension;
    private final List<PostIt> postIts = new ArrayList<PostIt>();

    public Area(char id, String title) {
        this.id = id;
        this.title = title;
    }

    public char getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public Dimension2D getMinimumDimension() {
        return this.minimumDimension;
    }

    public void setMinimunDimension(Dimension2D minimumDimension) {
        this.minimumDimension = minimumDimension;
    }

    public Dimension2D getDimension() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double heightWhenWidthIs(double width, StringBounder stringBounder) {
        AreaLayoutFixedWidth layout = new AreaLayoutFixedWidth(width);
        Map<PostIt, Point2D> pos = layout.getPositions(this.postIts, stringBounder);
        double max = 10.0;
        for (Map.Entry<PostIt, Point2D> ent : pos.entrySet()) {
            double y = ent.getKey().getDimension(stringBounder).getHeight() + ent.getValue().getY();
            max = Math.max(max, y);
        }
        return max + 10.0;
    }

    @Override
    public double widthWhenHeightIs(double height, StringBounder stringBounder) {
        throw new UnsupportedOperationException();
    }

    public void add(PostIt postIt) {
        this.postIts.add(postIt);
    }

    public void drawU(UGraphic ug, double width) {
        AreaLayoutFixedWidth layout = new AreaLayoutFixedWidth(width);
        Map<PostIt, Point2D> pos = layout.getPositions(this.postIts, ug.getStringBounder());
        for (Map.Entry<PostIt, Point2D> ent : pos.entrySet()) {
            UGraphic ugTranslated = ug.apply(new UTranslate(ent.getValue().getX(), ent.getValue().getY()));
            ent.getKey().drawU(ugTranslated);
        }
    }
}

