/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import znaishaded.net.sourceforge.plantuml.preproc.Truth;

public class EvalBoolean {
    private final String str;
    private int pos = -1;
    private char ch;
    private final Truth truth;

    public EvalBoolean(String str, Truth truth) {
        this.str = str;
        this.truth = truth;
    }

    private void nextChar() {
        ++this.pos;
        this.ch = this.pos < this.str.length() ? this.str.charAt(this.pos) : (char)'\u0000';
    }

    private boolean eat(char charToEat) {
        while (this.ch == ' ') {
            this.nextChar();
        }
        if (this.ch == charToEat) {
            this.nextChar();
            return true;
        }
        return false;
    }

    private boolean parseExpression() {
        boolean x = this.parseTerm();
        while (this.eat('|')) {
            this.eat('|');
            x |= this.parseTerm();
        }
        return x;
    }

    private boolean parseTerm() {
        boolean x = this.parseFactor();
        while (this.eat('&')) {
            this.eat('&');
            x &= this.parseFactor();
        }
        return x;
    }

    private boolean parseFactor() {
        boolean x;
        if (this.eat('!')) {
            return !this.parseFactor();
        }
        int startPos = this.pos;
        if (this.eat('(')) {
            x = this.parseExpression();
            this.eat(')');
        } else if (this.isIdentifier()) {
            while (this.isIdentifier()) {
                this.nextChar();
            }
            String func = this.str.substring(startPos, this.pos);
            x = this.truth.isTrue(func);
        } else {
            throw new IllegalArgumentException("Unexpected: " + this.ch);
        }
        return x;
    }

    private boolean isIdentifier() {
        return this.ch == '_' || this.ch == '$' || Character.isLetterOrDigit(this.ch);
    }

    public boolean eval() {
        this.nextChar();
        boolean x = this.parseExpression();
        if (this.pos < this.str.length()) {
            throw new IllegalArgumentException("Unexpected: " + this.ch);
        }
        return x;
    }
}

