/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandNope;
import znaishaded.net.sourceforge.plantuml.command.CommandScale;
import znaishaded.net.sourceforge.plantuml.command.UmlDiagramFactory;
import znaishaded.net.sourceforge.plantuml.core.DiagramType;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.command.CommandColorTask;
import znaishaded.net.sourceforge.plantuml.project.command.CommandGanttArrow;
import znaishaded.net.sourceforge.plantuml.project.command.CommandGanttArrow2;
import znaishaded.net.sourceforge.plantuml.project.command.CommandNoteBottom;
import znaishaded.net.sourceforge.plantuml.project.command.CommandPage;
import znaishaded.net.sourceforge.plantuml.project.command.CommandPrintBetween;
import znaishaded.net.sourceforge.plantuml.project.command.CommandPrintScale;
import znaishaded.net.sourceforge.plantuml.project.command.CommandSeparator;
import znaishaded.net.sourceforge.plantuml.project.command.NaturalCommand;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceAnd;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceAndAnd;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectDayAsDate;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectDayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectDaysAsDates;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectLinks;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectProject;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectResource;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectTask;
import znaishaded.net.sourceforge.plantuml.project.lang.SubjectToday;
import znaishaded.net.sourceforge.plantuml.style.CommandStyleImport;
import znaishaded.net.sourceforge.plantuml.style.CommandStyleMultilinesCSS;

public class GanttDiagramFactory
extends UmlDiagramFactory {
    private static final Collection<Command> cache = new ArrayList<Command>();

    private static final List<Subject> subjects() {
        return Arrays.asList(new SubjectTask(), new SubjectProject(), new SubjectDayOfWeek(), new SubjectDayAsDate(), new SubjectDaysAsDates(), new SubjectResource(), new SubjectToday(), new SubjectLinks());
    }

    public GanttDiagramFactory(DiagramType type) {
        super(type);
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.addTitleCommands(cmds);
        cmds.add(new CommandStyleMultilinesCSS());
        cmds.add(new CommandStyleImport());
        cmds.add(new CommandNope());
        cmds.addAll(GanttDiagramFactory.getLanguageCommands());
        cmds.add(new CommandGanttArrow());
        cmds.add(new CommandGanttArrow2());
        cmds.add(new CommandColorTask());
        cmds.add(new CommandSeparator());
        cmds.add(new CommandPrintScale());
        cmds.add(new CommandPrintBetween());
        cmds.add(new CommandScale());
        cmds.add(new CommandPage());
        cmds.add(new CommandNoteBottom());
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Command> getLanguageCommands() {
        Collection<Command> collection = cache;
        synchronized (collection) {
            if (cache.size() == 0) {
                for (Subject subject : GanttDiagramFactory.subjects()) {
                    for (SentenceSimple sentenceSimple : subject.getSentences()) {
                        cache.add(NaturalCommand.create(sentenceSimple));
                        for (SentenceSimple sentenceSimple2 : subject.getSentences()) {
                            if (sentenceSimple.getVerbPattern().equals(sentenceSimple2.getVerbPattern())) continue;
                            cache.add(NaturalCommand.create(new SentenceAnd(sentenceSimple, sentenceSimple2)));
                        }
                    }
                }
                for (Subject subject : GanttDiagramFactory.subjects()) {
                    for (SentenceSimple sentenceSimple : subject.getSentences()) {
                        for (SentenceSimple sentenceSimple3 : subject.getSentences()) {
                            for (SentenceSimple sentenceSimple4 : subject.getSentences()) {
                                if (sentenceSimple.getVerbPattern().equals(sentenceSimple3.getVerbPattern()) || sentenceSimple.getVerbPattern().equals(sentenceSimple4.getVerbPattern()) || sentenceSimple4.getVerbPattern().equals(sentenceSimple3.getVerbPattern())) continue;
                                cache.add(NaturalCommand.create(new SentenceAndAnd(sentenceSimple, sentenceSimple3, sentenceSimple4)));
                            }
                        }
                    }
                }
            }
        }
        return cache;
    }

    @Override
    public GanttDiagram createEmptyDiagram() {
        return new GanttDiagram();
    }
}

