/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.project.Load;
import znaishaded.net.sourceforge.plantuml.project.LoadPlanable;
import znaishaded.net.sourceforge.plantuml.project.PlanUtils;
import znaishaded.net.sourceforge.plantuml.project.Solver;
import znaishaded.net.sourceforge.plantuml.project.core.AbstractTask;
import znaishaded.net.sourceforge.plantuml.project.core.Resource;
import znaishaded.net.sourceforge.plantuml.project.core.Task;
import znaishaded.net.sourceforge.plantuml.project.core.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project.core.TaskCode;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.project.time.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project.time.GCalendar;
import znaishaded.net.sourceforge.plantuml.project.time.Wink;

public class TaskImpl
extends AbstractTask
implements Task,
LoadPlanable {
    private final SortedSet<Wink> pausedDay = new TreeSet<Wink>();
    private final Set<DayOfWeek> pausedDayOfWeek = new HashSet<DayOfWeek>();
    private final Solver solver;
    private final Map<Resource, Integer> resources = new LinkedHashMap<Resource, Integer>();
    private final LoadPlanable defaultPlan;
    private final GCalendar calendar;
    private boolean diamond;
    private int completion = 100;
    private Display note;
    private Url url;
    private CenterBorderColor colors;

    @Override
    public void setUrl(Url url) {
        this.url = url;
    }

    public TaskImpl(TaskCode code, LoadPlanable defaultPlan, GCalendar calendar) {
        super(code);
        this.calendar = calendar;
        this.defaultPlan = defaultPlan;
        this.solver = new Solver(this);
        this.setStart(new Wink(0));
        this.setLoad(Load.inWinks(1));
    }

    @Override
    public int getLoadAt(Wink instant) {
        if (this.pausedDay.contains(instant)) {
            return 0;
        }
        if (this.pausedDayOfWeek(instant)) {
            return 0;
        }
        LoadPlanable result = this.defaultPlan;
        if (this.resources.size() > 0) {
            result = PlanUtils.multiply(this.defaultPlan, this.getRessourcePlan());
        }
        return result.getLoadAt(instant);
    }

    private boolean pausedDayOfWeek(Wink instant) {
        for (DayOfWeek dayOfWeek : this.pausedDayOfWeek) {
            if (this.calendar.toDayAsDate(instant).getDayOfWeek() != dayOfWeek) continue;
            return true;
        }
        return false;
    }

    public int loadForResource(Resource res, Wink instant) {
        if (this.resources.keySet().contains(res) && instant.compareTo(this.getStart()) >= 0 && instant.compareTo(this.getEnd()) <= 0) {
            if (res.isClosedAt(instant)) {
                return 0;
            }
            return this.resources.get(res);
        }
        return 0;
    }

    @Override
    public void addPause(Wink pause) {
        this.pausedDay.add(pause);
    }

    @Override
    public void addPause(DayOfWeek pause) {
        this.pausedDayOfWeek.add(pause);
    }

    private LoadPlanable getRessourcePlan() {
        if (this.resources.size() == 0) {
            throw new IllegalStateException();
        }
        return new LoadPlanable(){

            @Override
            public int getLoadAt(Wink instant) {
                int result = 0;
                for (Map.Entry ent : TaskImpl.this.resources.entrySet()) {
                    Resource res = (Resource)ent.getKey();
                    if (res.isClosedAt(instant)) continue;
                    int percentage = (Integer)ent.getValue();
                    result += percentage;
                }
                return result;
            }
        };
    }

    public String getPrettyDisplay() {
        if (this.resources.size() > 0) {
            StringBuilder result = new StringBuilder(this.code.getSimpleDisplay());
            result.append(" ");
            Iterator<Map.Entry<Resource, Integer>> it = this.resources.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Resource, Integer> ent = it.next();
                result.append("{");
                result.append(ent.getKey().getName());
                int percentage = ent.getValue();
                if (percentage != 100) {
                    result.append(":" + percentage + "%");
                }
                result.append("}");
                if (!it.hasNext()) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return this.code.getSimpleDisplay();
    }

    public String toString() {
        return this.code.toString();
    }

    public String debug() {
        return "" + this.getStart() + " ---> " + this.getEnd() + "   [" + this.getLoad() + "]";
    }

    @Override
    public TaskCode getCode() {
        return this.code;
    }

    @Override
    public Wink getStart() {
        Wink result = (Wink)this.solver.getData(TaskAttribute.START);
        while (this.getLoadAt(result) == 0) {
            result = result.increment();
        }
        return result;
    }

    @Override
    public Wink getEnd() {
        return (Wink)this.solver.getData(TaskAttribute.END);
    }

    @Override
    public Load getLoad() {
        return (Load)this.solver.getData(TaskAttribute.LOAD);
    }

    @Override
    public void setLoad(Load load) {
        this.solver.setData(TaskAttribute.LOAD, load);
    }

    @Override
    public void setStart(Wink start) {
        this.solver.setData(TaskAttribute.START, start);
    }

    @Override
    public void setEnd(Wink end) {
        this.solver.setData(TaskAttribute.END, end);
    }

    @Override
    public void setColors(CenterBorderColor colors) {
        this.colors = colors;
    }

    @Override
    public void addResource(Resource resource, int percentage) {
        this.resources.put(resource, percentage);
    }

    @Override
    public void setDiamond(boolean diamond) {
        this.diamond = diamond;
    }

    @Override
    public boolean isDiamond() {
        return this.diamond;
    }

    @Override
    public void setCompletion(int completion) {
        this.completion = completion;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final CenterBorderColor getColors() {
        return this.colors;
    }

    public final int getCompletion() {
        return this.completion;
    }

    public final Collection<Wink> getAllPaused() {
        TreeSet<Wink> result = new TreeSet<Wink>(this.pausedDay);
        for (DayOfWeek dayOfWeek : this.pausedDayOfWeek) {
            this.addAll(result, dayOfWeek);
        }
        return Collections.unmodifiableCollection(result);
    }

    private void addAll(SortedSet<Wink> result, DayOfWeek dayOfWeek) {
        Day start = this.calendar.toDayAsDate(this.getStart());
        Day end = this.calendar.toDayAsDate(this.getEnd());
        Day current = start;
        while (current.compareTo(end) <= 0) {
            if (current.getDayOfWeek() == dayOfWeek) {
                result.add(this.calendar.fromDayAsDate(current));
            }
            current = current.next();
        }
    }

    @Override
    public void setNote(Display note) {
        this.note = note;
    }

    public Display getNote() {
        return this.note;
    }
}

