/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.lang;

import java.util.Arrays;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.project.Failable;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.lang.CenterBorderColor;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementClose;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementInColors2;
import znaishaded.net.sourceforge.plantuml.project.lang.ComplementOpen;
import znaishaded.net.sourceforge.plantuml.project.lang.SentenceSimple;
import znaishaded.net.sourceforge.plantuml.project.lang.Subject;
import znaishaded.net.sourceforge.plantuml.project.lang.Verbs;
import znaishaded.net.sourceforge.plantuml.project.time.Day;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;

public class SubjectDayAsDate
implements Subject {
    public Failable<Day> getMe(GanttDiagram project, RegexResult arg) {
        int day = Integer.parseInt(arg.get("DAY", 0));
        int month = Integer.parseInt(arg.get("MONTH", 0));
        int year = Integer.parseInt(arg.get("YEAR", 0));
        return Failable.ok(Day.create(year, month, day));
    }

    @Override
    public Collection<? extends SentenceSimple> getSentences() {
        return Arrays.asList(new Close(), new Open(), new InColor());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("YEAR", "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("MONTH", "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("DAY", "([\\d]{1,2})"));
    }

    class InColor
    extends SentenceSimple {
        public InColor() {
            super(SubjectDayAsDate.this, Verbs.isOrAre(), new ComplementInColors2());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            HColor color = ((CenterBorderColor)complement).getCenter();
            project.colorDay((Day)subject, color);
            return CommandExecutionResult.ok();
        }
    }

    class Open
    extends SentenceSimple {
        public Open() {
            super(SubjectDayAsDate.this, Verbs.isOrAre(), new ComplementOpen());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.openDayAsDate((Day)subject);
            return CommandExecutionResult.ok();
        }
    }

    class Close
    extends SentenceSimple {
        public Close() {
            super(SubjectDayAsDate.this, Verbs.isOrAre(), new ComplementClose());
        }

        @Override
        public CommandExecutionResult execute(GanttDiagram project, Object subject, Object complement) {
            project.closeDayAsDate((Day)subject);
            return CommandExecutionResult.ok();
        }
    }
}

