/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.salt.element;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.salt.element.AbstractElement;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementMenuEntry;
import znaishaded.net.sourceforge.plantuml.salt.element.ElementMenuPopup;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ElementMenuBar
extends AbstractElement {
    private final Collection<ElementMenuEntry> entries = new ArrayList<ElementMenuEntry>();
    private final Map<ElementMenuEntry, ElementMenuPopup> popups = new HashMap<ElementMenuEntry, ElementMenuPopup>();
    private final UFont font;
    private final ISkinSimple spriteContainer;

    public ElementMenuBar(UFont font, ISkinSimple spriteContainer) {
        this.font = font;
        this.spriteContainer = spriteContainer;
    }

    public void addEntry(String s2) {
        this.entries.add(new ElementMenuEntry(s2, this.font, this.spriteContainer));
    }

    public void addSubEntry(String s2, String sub) {
        ElementMenuPopup popup = this.getPopup(this.getElementMenuEntry(s2));
        popup.addEntry(sub);
    }

    private ElementMenuPopup getPopup(ElementMenuEntry s2) {
        ElementMenuPopup popup = this.popups.get(s2);
        if (popup == null) {
            popup = new ElementMenuPopup(this.font, this.spriteContainer);
            this.popups.put(s2, popup);
        }
        return popup;
    }

    private ElementMenuEntry getElementMenuEntry(String n) {
        for (ElementMenuEntry entry : this.entries) {
            if (!entry.getText().equals(n)) continue;
            return entry;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Dimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        double w = 0.0;
        double h2 = 0.0;
        for (ElementMenuEntry entry : this.entries) {
            Dimension2D dim = entry.getPreferredDimension(stringBounder, x, y);
            w += dim.getWidth() + 10.0;
            h2 = Math.max(h2, dim.getHeight());
        }
        return new Dimension2DDouble(w, h2);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, Dimension2D dimToUse) {
        Dimension2D preferred = this.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        double x1 = 0.0;
        if (zIndex == 0) {
            ug.apply(HColorSet.instance().getColorIfValid("#DDDDDD").bg()).draw(new URectangle(dimToUse.getWidth(), dimToUse.getHeight()));
            for (ElementMenuEntry entry : this.entries) {
                entry.drawU(ug.apply(UTranslate.dx(x1)), zIndex, dimToUse);
                double w = entry.getPreferredDimension(ug.getStringBounder(), x1, 0.0).getWidth();
                entry.setX(x1);
                x1 += w + 10.0;
            }
            return;
        }
        if (zIndex == 1) {
            for (ElementMenuEntry entry : this.popups.keySet()) {
                entry.setBackground(HColorSet.instance().getColorIfValid("#BBBBBB"));
            }
            double y1 = preferred.getHeight();
            for (Map.Entry<ElementMenuEntry, ElementMenuPopup> ent : this.popups.entrySet()) {
                ElementMenuPopup p = ent.getValue();
                double xpopup = ent.getKey().getX();
                p.drawU(ug.apply(new UTranslate(xpopup, y1)), zIndex, p.getPreferredDimension(ug.getStringBounder(), xpopup, y1));
            }
        }
    }
}

