/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram;

import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.MessageExoType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.style.StyleBuilder;

public class MessageExo
extends AbstractMessage {
    private final MessageExoType type;
    private final Participant participant;
    private final boolean shortArrow;

    public MessageExo(StyleBuilder styleBuilder, Participant p, MessageExoType type, Display label, ArrowConfiguration arrowConfiguration, String messageNumber, boolean shortArrow) {
        super(styleBuilder, label, arrowConfiguration, messageNumber);
        this.participant = p;
        this.type = type;
        this.shortArrow = shortArrow;
    }

    public boolean isShortArrow() {
        return this.shortArrow;
    }

    @Override
    protected NotePosition overideNotePosition(NotePosition notePosition) {
        if (this.type == MessageExoType.FROM_LEFT || this.type == MessageExoType.TO_LEFT) {
            return NotePosition.RIGHT;
        }
        if (this.type == MessageExoType.FROM_RIGHT || this.type == MessageExoType.TO_RIGHT) {
            return NotePosition.LEFT;
        }
        throw new IllegalStateException();
    }

    @Override
    public Participant getParticipant1() {
        return this.participant;
    }

    @Override
    public Participant getParticipant2() {
        return this.participant;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public final MessageExoType getType() {
        return this.type;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.participant == someone;
    }

    @Override
    public boolean compatibleForCreate(Participant p) {
        return p == this.participant;
    }

    @Override
    public boolean isSelfMessage() {
        return false;
    }
}

