/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.FrontierComplex;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.FrontierStack;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;

class FrontierStackImpl
implements FrontierStack {
    private final List<Stack> all;

    public FrontierStackImpl(double freeY, int rangeEnd) {
        Stack s2 = new Stack(new FrontierComplex(freeY, rangeEnd));
        this.all = Collections.singletonList(s2);
    }

    private FrontierStackImpl(List<Stack> all) {
        this.all = Collections.unmodifiableList(all);
    }

    private FrontierComplex getLast() {
        return this.all.get(this.all.size() - 1).current;
    }

    @Override
    public double getFreeY(ParticipantRange range) {
        return this.getLast().getFreeY(range);
    }

    @Override
    public FrontierStackImpl add(double delta, ParticipantRange range) {
        ArrayList<Stack> result = new ArrayList<Stack>(this.all);
        Stack s2 = new Stack(this.getLast().add(delta, range));
        result.set(result.size() - 1, s2);
        return new FrontierStackImpl(result);
    }

    @Override
    public FrontierStack openBar() {
        ArrayList<Stack> result = new ArrayList<Stack>(this.all);
        Stack s2 = new Stack(this.getLast().copy());
        result.add(s2);
        return new FrontierStackImpl(result);
    }

    @Override
    public FrontierStack restore() {
        ArrayList<Stack> result = new ArrayList<Stack>(this.all);
        Stack openedBar = (Stack)result.get(result.size() - 2);
        Stack lastStack = (Stack)result.get(result.size() - 1);
        result.set(result.size() - 2, openedBar.addEnvelop(lastStack.current));
        result.remove(result.size() - 1);
        Stack s2 = new Stack(openedBar.current.copy());
        result.add(s2);
        return new FrontierStackImpl(result);
    }

    @Override
    public FrontierStack closeBar() {
        ArrayList<Stack> result = new ArrayList<Stack>(this.all);
        Stack openedBar = (Stack)result.get(result.size() - 2);
        Stack lastStack = (Stack)result.get(result.size() - 1);
        Stack merge = openedBar.addEnvelop(lastStack.current);
        result.set(result.size() - 2, new Stack(merge.envelop));
        result.remove(result.size() - 1);
        return new FrontierStackImpl(result);
    }

    public FrontierStackImpl copy() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "nb=" + this.all.size() + " " + this.getLast().toString();
    }

    class Stack {
        private final FrontierComplex current;
        private final FrontierComplex envelop;

        Stack(FrontierComplex current) {
            this(current, null);
        }

        private Stack(FrontierComplex current, FrontierComplex envelop) {
            this.current = current;
            this.envelop = envelop;
        }

        Stack addEnvelop(FrontierComplex env) {
            if (this.envelop == null) {
                return new Stack(this.current, env);
            }
            return new Stack(this.current, this.envelop.mergeMax(env));
        }
    }
}

