/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sprite;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class ListSpriteDiagram
extends UmlDiagram {
    public ListSpriteDiagram(ISkinSimple skinParam) {
        super(skinParam);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Sprites)");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.HELP;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        int margin2;
        int margin1;
        TextBlock result = this.getTable();
        double dpiFactor = 1.0;
        if (SkinParam.USE_STYLES()) {
            margin1 = SkinParam.zeroMargin(10);
            margin2 = SkinParam.zeroMargin(10);
        } else {
            margin1 = 10;
            margin2 = 10;
        }
        ImageBuilder imageBuilder = ImageBuilder.buildD(this.getSkinParam(), ClockwiseTopRightBottomLeft.margin1margin2(margin1, margin2), this.getAnimation(), fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 1.0);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private TextBlock getTable() {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                double x = 0.0;
                double y = 0.0;
                double rawHeight = 0.0;
                for (String n : ListSpriteDiagram.this.getSkinParam().getAllSpriteNames()) {
                    Sprite sprite = ListSpriteDiagram.this.getSkinParam().getSprite(n);
                    TextBlock blockName = Display.create(n).create(FontConfiguration.blackBlueTrue(UFont.sansSerif(14)), HorizontalAlignment.LEFT, ListSpriteDiagram.this.getSkinParam());
                    TextBlock tb = sprite.asTextBlock(HColorUtils.BLACK, 1.0);
                    tb = TextBlockUtils.mergeTB(tb, blockName, HorizontalAlignment.CENTER);
                    tb.drawU(ug.apply(new UTranslate(x, y)));
                    Dimension2D dim = tb.calculateDimension(ug.getStringBounder());
                    rawHeight = Math.max(rawHeight, dim.getHeight());
                    x += dim.getWidth();
                    if (!((x += 30.0) > 1024.0)) continue;
                    x = 0.0;
                    y += rawHeight + 50.0;
                    rawHeight = 0.0;
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(1024.0, 1024.0);
            }
        };
    }
}

