/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.stats.HumanDuration;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsTable;

public class HtmlConverter {
    private final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final Stats stats;

    public HtmlConverter(Stats stats) {
        this.stats = stats;
    }

    public String toHtml() {
        StringBuilder result = new StringBuilder();
        result.append("<html>");
        result.append("<style type=\"text/css\">");
        result.append("body { font-family: arial, helvetica, sans-serif; font-size: 12px; font-weight: normal; color: black; background: white;}");
        result.append("th,td { font-size: 12px;}");
        result.append("table { border-collapse: collapse; border-style: none;}");
        result.append("</style>");
        result.append("<h2>Statistics</h2>");
        this.printTableHtml(result, this.stats.getLastSessions());
        StatsTable currentSessionByDiagramType = this.stats.getCurrentSessionByDiagramType();
        if (currentSessionByDiagramType.getLines().size() > 1) {
            result.append("<h2>Current session statistics</h2>");
            this.printTableHtml(result, currentSessionByDiagramType);
            result.append("<p>");
            this.printTableHtml(result, this.stats.getCurrentSessionByFormat());
        }
        result.append("<h2>General statistics since ever</h2>");
        this.printTableHtml(result, this.stats.getAllByDiagramType());
        result.append("<p>");
        this.printTableHtml(result, this.stats.getAllByFormat());
        result.append("</html>");
        return result.toString();
    }

    private void printTableHtml(StringBuilder result, StatsTable table) {
        Collection<StatsColumn> headers = table.getColumnHeaders();
        result.append("<table border=1 cellspacing=0 cellpadding=2>");
        result.append(this.getHtmlHeader(headers));
        List<StatsLine> lines = table.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            StatsLine line = lines.get(i);
            boolean bold = i == lines.size() - 1;
            result.append(this.getCreoleLine(headers, line, bold));
        }
        result.append("</table>");
    }

    private String getCreoleLine(Collection<StatsColumn> headers, StatsLine line, boolean bold) {
        StringBuilder result = new StringBuilder();
        if (bold) {
            result.append("<tr bgcolor=#f0f0f0>");
        } else {
            result.append("<tr bgcolor=#fcfcfc>");
        }
        for (StatsColumn col : headers) {
            Object v = line.getValue(col);
            if (v instanceof Long || v instanceof HumanDuration) {
                result.append("<td align=right>");
            } else {
                result.append("<td>");
            }
            if (bold) {
                result.append("<b>");
            }
            if (v instanceof Long) {
                result.append(String.format("%,d", v));
            } else if (v instanceof Date) {
                result.append(this.formatter.format(v));
            } else if (v == null || v.toString().length() == 0) {
                result.append(" ");
            } else {
                result.append(v.toString());
            }
            if (bold) {
                result.append("</b>");
            }
            result.append("</td>");
        }
        result.append("</tr>");
        return result.toString();
    }

    private String getHtmlHeader(Collection<StatsColumn> headers) {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr bgcolor=#e0e0e0>");
        for (StatsColumn col : headers) {
            sb.append("<td><b>");
            sb.append(col.getTitle().replace("\\n", "<br>"));
            sb.append("</b></td>");
        }
        sb.append("</tr>");
        return sb.toString();
    }
}

