/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram.graphic;

import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;

public class PentaAShape
implements UDrawable {
    private final double width;
    private final double height;
    private final SymbolContext context;
    private final double delta = 12.0;

    private PentaAShape(double width, double height, SymbolContext context) {
        this.width = width;
        this.height = height;
        this.context = context;
    }

    public static PentaAShape create(double width, double height, SymbolContext context) {
        return new PentaAShape(width, height, context);
    }

    @Override
    public void drawU(UGraphic ug) {
        UPolygon polygon = new UPolygon();
        polygon.addPoint(0.0, 0.0);
        polygon.addPoint(this.width - 12.0, 0.0);
        polygon.addPoint(this.width, this.height / 2.0);
        polygon.addPoint(this.width - 12.0, this.height);
        polygon.addPoint(0.0, this.height);
        this.context.withForeColor(this.context.getBackColor()).apply(ug).draw(polygon);
        UPath path = new UPath();
        path.moveTo(0.0, 0.0);
        path.lineTo(this.width - 12.0, 0.0);
        path.lineTo(this.width, this.height / 2.0);
        path.lineTo(this.width - 12.0, this.height);
        path.lineTo(0.0, this.height);
        this.context.apply(ug).draw(path);
    }
}

