/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Rectangle2D;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorGradient;

public class DriverRectangleEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverRectangleEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, EpsGraphics eps) {
        HColor back;
        URectangle rect = (URectangle)ushape;
        double width = rect.getWidth();
        double height = rect.getHeight();
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            Rectangle2D.Double orig = new Rectangle2D.Double(x, y, width, height);
            Rectangle2D.Double r = clip.getClippedRectangle(orig);
            if (r.height < 0.0) {
                return;
            }
            x = r.x;
            y = r.y;
            width = r.width;
            height = r.height;
        }
        double rx = rect.getRx();
        double ry = rect.getRy();
        if (rect.getDeltaShadow() != 0.0) {
            eps.epsRectangleShadow(x, y, width, height, rx / 2.0, ry / 2.0, rect.getDeltaShadow());
        }
        if ((back = param.getBackcolor()) instanceof HColorGradient) {
            eps.setStrokeColor(mapper.toColor(param.getColor()));
            eps.epsRectangle(x, y, width, height, rx / 2.0, ry / 2.0, (HColorGradient)back, mapper);
        } else {
            eps.setStrokeColor(mapper.toColor(param.getColor()));
            eps.setFillColor(mapper.toColor(param.getBackcolor()));
            eps.setStrokeWidth(param.getStroke().getThickness(), param.getStroke().getDashVisible(), param.getStroke().getDashSpace());
            eps.epsRectangle(x, y, width, height, rx / 2.0, ry / 2.0);
        }
    }
}

