/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal;

import java.util.ArrayList;
import java.util.List;
import znaishaded.org.commonmark.internal.util.Escaping;
import znaishaded.org.commonmark.internal.util.LinkScanner;
import znaishaded.org.commonmark.internal.util.Parsing;
import znaishaded.org.commonmark.node.LinkReferenceDefinition;

public class LinkReferenceDefinitionParser {
    private State state = State.START_DEFINITION;
    private final StringBuilder paragraph = new StringBuilder();
    private final List<LinkReferenceDefinition> definitions = new ArrayList<LinkReferenceDefinition>();
    private StringBuilder label;
    private String normalizedLabel;
    private String destination;
    private char titleDelimiter;
    private StringBuilder title;
    private boolean referenceValid = false;

    public void parse(CharSequence line) {
        if (this.paragraph.length() != 0) {
            this.paragraph.append('\n');
        }
        this.paragraph.append(line);
        int i = 0;
        while (i < line.length()) {
            switch (this.state) {
                case PARAGRAPH: {
                    return;
                }
                case START_DEFINITION: {
                    i = this.startDefinition(line, i);
                    break;
                }
                case LABEL: {
                    i = this.label(line, i);
                    break;
                }
                case DESTINATION: {
                    i = this.destination(line, i);
                    break;
                }
                case START_TITLE: {
                    i = this.startTitle(line, i);
                    break;
                }
                case TITLE: {
                    i = this.title(line, i);
                }
            }
            if (i != -1) continue;
            this.state = State.PARAGRAPH;
            return;
        }
    }

    CharSequence getParagraphContent() {
        return this.paragraph;
    }

    List<LinkReferenceDefinition> getDefinitions() {
        this.finishReference();
        return this.definitions;
    }

    State getState() {
        return this.state;
    }

    private int startDefinition(CharSequence line, int i) {
        if ((i = Parsing.skipSpaceTab(line, i, line.length())) >= line.length() || line.charAt(i) != '[') {
            return -1;
        }
        this.state = State.LABEL;
        this.label = new StringBuilder();
        int labelStart = i + 1;
        if (labelStart >= line.length()) {
            this.label.append('\n');
        }
        return labelStart;
    }

    private int label(CharSequence line, int i) {
        int afterLabel = LinkScanner.scanLinkLabelContent(line, i);
        if (afterLabel == -1) {
            return -1;
        }
        this.label.append(line, i, afterLabel);
        if (afterLabel >= line.length()) {
            this.label.append('\n');
            return afterLabel;
        }
        if (line.charAt(afterLabel) == ']') {
            int colon = afterLabel + 1;
            if (colon >= line.length() || line.charAt(colon) != ':') {
                return -1;
            }
            if (this.label.length() > 999) {
                return -1;
            }
            String normalizedLabel = Escaping.normalizeLabelContent(this.label.toString());
            if (normalizedLabel.isEmpty()) {
                return -1;
            }
            this.normalizedLabel = normalizedLabel;
            this.state = State.DESTINATION;
            return Parsing.skipSpaceTab(line, colon + 1, line.length());
        }
        return -1;
    }

    private int destination(CharSequence line, int i) {
        int afterDestination = LinkScanner.scanLinkDestination(line, i = Parsing.skipSpaceTab(line, i, line.length()));
        if (afterDestination == -1) {
            return -1;
        }
        this.destination = line.charAt(i) == '<' ? line.subSequence(i + 1, afterDestination - 1).toString() : line.subSequence(i, afterDestination).toString();
        int afterSpace = Parsing.skipSpaceTab(line, afterDestination, line.length());
        if (afterSpace >= line.length()) {
            this.referenceValid = true;
            this.paragraph.setLength(0);
        } else if (afterSpace == afterDestination) {
            return -1;
        }
        this.state = State.START_TITLE;
        return afterSpace;
    }

    private int startTitle(CharSequence line, int i) {
        if ((i = Parsing.skipSpaceTab(line, i, line.length())) >= line.length()) {
            this.state = State.START_DEFINITION;
            return i;
        }
        this.titleDelimiter = '\u0000';
        char c = line.charAt(i);
        switch (c) {
            case '\"': 
            case '\'': {
                this.titleDelimiter = c;
                break;
            }
            case '(': {
                this.titleDelimiter = (char)41;
            }
        }
        if (this.titleDelimiter != '\u0000') {
            this.state = State.TITLE;
            this.title = new StringBuilder();
            if (++i == line.length()) {
                this.title.append('\n');
            }
        } else {
            this.finishReference();
            this.state = State.START_DEFINITION;
        }
        return i;
    }

    private int title(CharSequence line, int i) {
        int afterTitle = LinkScanner.scanLinkTitleContent(line, i, this.titleDelimiter);
        if (afterTitle == -1) {
            return -1;
        }
        this.title.append(line.subSequence(i, afterTitle));
        if (afterTitle >= line.length()) {
            this.title.append('\n');
            return afterTitle;
        }
        int afterTitleDelimiter = afterTitle + 1;
        int afterSpace = Parsing.skipSpaceTab(line, afterTitleDelimiter, line.length());
        if (afterSpace != line.length()) {
            return -1;
        }
        this.referenceValid = true;
        this.finishReference();
        this.paragraph.setLength(0);
        this.state = State.START_DEFINITION;
        return afterSpace;
    }

    private void finishReference() {
        if (!this.referenceValid) {
            return;
        }
        String d = Escaping.unescapeString(this.destination);
        String t = this.title != null ? Escaping.unescapeString(this.title.toString()) : null;
        this.definitions.add(new LinkReferenceDefinition(this.normalizedLabel, d, t));
        this.label = null;
        this.referenceValid = false;
        this.normalizedLabel = null;
        this.destination = null;
        this.title = null;
    }

    static enum State {
        START_DEFINITION,
        LABEL,
        DESTINATION,
        START_TITLE,
        TITLE,
        PARAGRAPH;

    }
}

