/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cli;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class DocScaffolding {
    private final Path workingDir;
    private final Map<String, List<String>> fileNameByDirName;

    public DocScaffolding(Path workingDir) {
        this.workingDir = workingDir;
        this.fileNameByDirName = new LinkedHashMap<String, List<String>>();
    }

    public void create() {
        this.createPages();
        this.createToc();
        this.createAuxiliaryContentFiles();
        this.createMeta();
        this.createPluginParams();
        this.createIndex();
        this.createLookupPaths();
    }

    private void createLookupPaths() {
        this.createFileFromResource("lookup-paths");
    }

    private void createMeta() {
        this.createFileFromResource("meta.json");
    }

    private void createPluginParams() {
        this.createFileFromResource("plugin-params.json");
    }

    private void createIndex() {
        this.createFileFromResource("scaffold-index.md", "index.md");
    }

    private void createPages() {
        this.createPage("chapter-one", "getting-started");
        this.createPage("chapter-one", "page-two");
        this.createPage("chapter-two", "page-three");
        this.createPage("chapter-two", "page-four");
        this.createFooter();
    }

    private void createToc() {
        String toc = this.fileNameByDirName.keySet().stream().map(this::buildTocSection).collect(Collectors.joining("\n"));
        FileUtils.writeTextContent(this.workingDir.resolve("toc"), toc);
    }

    private void createAuxiliaryContentFiles() {
        this.createAuxiliaryContentFile("file-name.js");
    }

    private void createFileFromResource(String resourceName) {
        this.createFileFromResource(resourceName, resourceName);
    }

    private void createFileFromResource(String resourceName, String destName) {
        FileUtils.writeTextContent(this.workingDir.resolve(destName), ResourceUtils.textContent(resourceName));
    }

    private String buildTocSection(String dirName) {
        List<String> fileNames = this.fileNameByDirName.get(dirName);
        return dirName + "\n    " + String.join((CharSequence)"\n    ", fileNames);
    }

    private void createPage(String dirName, String fileName) {
        this.registerPage(dirName, fileName);
        String withExtension = fileName + ".md";
        FileUtils.writeTextContent(this.workingDir.resolve(dirName).resolve(withExtension), ResourceUtils.textContent(withExtension));
    }

    private void createFooter() {
        String footerName = "footer.md";
        FileUtils.writeTextContent(this.workingDir.resolve(footerName), ResourceUtils.textContent(footerName));
    }

    private void registerPage(String dirName, String fileName) {
        List fileNames = this.fileNameByDirName.computeIfAbsent(dirName, k -> new ArrayList());
        fileNames.add(fileName);
    }

    private void createAuxiliaryContentFile(String resourceFilePath) {
        FileUtils.writeTextContent(this.workingDir.resolve(resourceFilePath), ResourceUtils.textContent(resourceFilePath));
    }
}

