/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.doxygen.parser;

import org.testingisdocumenting.znai.doxygen.parser.DoxygenCodeBlockSimple;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Node;
import znaishaded.org.apache.commons.io.FilenameUtils;

public class DoxygenProgramListingParser {
    private final Node node;
    private final StringBuilder codeBlock;
    private final String fileName;

    private DoxygenProgramListingParser(Node node) {
        this.node = node;
        this.codeBlock = new StringBuilder();
        this.fileName = XmlUtils.getAttributeText(node, "filename", "");
    }

    public static DoxygenCodeBlockSimple parseAsSimpleCodeBlock(Node node) {
        DoxygenProgramListingParser parser = new DoxygenProgramListingParser(node);
        return parser.parse();
    }

    private DoxygenCodeBlockSimple parse() {
        XmlUtils.childrenNodesStreamByName(this.node, "codeline").forEach(this::handleLine);
        return new DoxygenCodeBlockSimple(FilenameUtils.getExtension(this.fileName), this.codeBlock.toString());
    }

    private void handleLine(Node lineNode) {
        XmlUtils.forEach(lineNode.getChildNodes(), this::extractText);
        this.codeBlock.append("\n");
    }

    private void extractText(Node node) {
        if (node.getNodeName().equals("sp")) {
            this.codeBlock.append(" ");
        } else if (node.getNodeType() == 3) {
            this.codeBlock.append(node.getTextContent());
        }
        XmlUtils.forEach(node.getChildNodes(), this::extractText);
    }
}

