/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.attention;

import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public abstract class AttentionSignFencePluginBase
implements FencePlugin {
    private MarkupParserResult parserResult;

    @Override
    public String id() {
        return "attention-" + this.type();
    }

    protected abstract String type();

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add("label", PluginParamType.STRING, "optional label to put next to the icon", "\"Consider\")");
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams, String content) {
        MarkupParser markupParser = componentsRegistry.defaultParser();
        this.parserResult = markupParser.parse(markupPath, content);
        Map<String, Object> props = pluginParams.getOpts().toMap();
        props.put("attentionType", this.type());
        props.put("content", this.parserResult.getDocElement().contentToListOfMaps());
        return PluginResult.docElement("AttentionBlock", props);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return this.parserResult.getAuxiliaryFiles().stream();
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }
}

