/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.utils.StringUtils;

class TextContentExtractor {
    static final String SURROUNDED_BY_KEY = "surroundedBy";
    static final String SURROUNDED_BY_SEPARATOR_KEY = "surroundedBySeparator";
    static final String SURROUNDED_BY_KEEP_KEY = "surroundedByKeep";
    static final String START_LINE_KEY = "startLine";
    static final String END_LINE_KEY = "endLine";
    static final String NUMBER_OF_LINES_KEY = "numberOfLines";
    static final String EXCLUDE_START_KEY = "excludeStart";
    static final String EXCLUDE_END_KEY = "excludeEnd";
    static final String EXCLUDE_START_END_KEY = "excludeStartEnd";
    static final String INCLUDE_KEY = "include";
    static final String EXCLUDE_KEY = "exclude";
    static final String INCLUDE_REGEXP_KEY = "includeRegexp";
    static final String EXCLUDE_REGEXP_KEY = "excludeRegexp";
    static final String REPLACE_KEY = "replace";

    private TextContentExtractor() {
    }

    public static PluginParamsDefinition createParamsDefinition() {
        return new PluginParamsDefinition().add(SURROUNDED_BY_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "markers to use to extract portion of a snippet", "\"example-of-transaction\" or [\"example-of-creation\", \"example-of-consumption\"]").add(SURROUNDED_BY_SEPARATOR_KEY, PluginParamType.LIST_OR_SINGLE_STRING_WITH_NULLS, "separator(s) to use for multiple surrounded by blocks", "\"...\" or [\"\", \"...\"]").add(SURROUNDED_BY_KEEP_KEY, PluginParamType.BOOLEAN, "keep surrounded by text", "true").add(START_LINE_KEY, PluginParamType.STRING, "partial match of start line for snippet extraction", "\"class\"").add(END_LINE_KEY, PluginParamType.STRING, "partial match of end line for snippet extraction", "\"class\"").add(NUMBER_OF_LINES_KEY, PluginParamType.NUMBER, "number of lines to extract given start line", "10").add(EXCLUDE_START_KEY, PluginParamType.BOOLEAN, "exclude start line for snippet extraction", "true").add(EXCLUDE_END_KEY, PluginParamType.BOOLEAN, "exclude end line for snippet extraction", "true").add(EXCLUDE_START_END_KEY, PluginParamType.BOOLEAN, "exclude start and end line for snippet extraction", "true").add(INCLUDE_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "include only lines containing provided text(s)", "\"import\" or [\"class\", \"import\"").add(EXCLUDE_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "exclude lines containing provided text(s)", "\"// marker\" or [\"// marker1\", \"// marker2\"").add(INCLUDE_REGEXP_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "include only lines matching provided regexp(s)", "\"import org.util.*key\" or [\"class R*Base\", \"import B*One\"").add(EXCLUDE_REGEXP_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "exclude lines matching provided regexp(s)", "\"// marker-.*-fin\" or [\"// marker-.*-fin\", \"// another-.*-end\"").add(REPLACE_KEY, PluginParamType.LIST_OF_ANY, "replaces values in the resulting snippet", "[\"old-value\", \"new-value\"] or [[\"old-value1\", \"new-value1\"], [\"old-value2\", \"new-value2\"]]");
    }

    public static String extractText(String contentId, String content, PluginParamsOpts opts) {
        Text text = new Text(contentId, content);
        Text surroundedBy = TextContentExtractor.cropSurroundedBy(contentId, text, opts);
        Text croppedAtStart = TextContentExtractor.cropStart(surroundedBy, opts);
        Text croppedAtEnd = TextContentExtractor.cropEnd(croppedAtStart, opts);
        Text replacedAll = TextContentExtractor.replaceAll(croppedAtEnd, opts);
        Text withExcludedStart = TextContentExtractor.excludeStart(replacedAll, opts);
        Text withExcludedStartEnd = TextContentExtractor.excludeEnd(withExcludedStart, opts);
        Text withIncludeContains = TextContentExtractor.includeContains(withExcludedStartEnd, opts);
        Text withExcludeContains = TextContentExtractor.excludeContains(withIncludeContains, opts);
        Text withIncludeRegexp = TextContentExtractor.includeRegexp(withExcludeContains, opts);
        Text withExcludedRegexp = TextContentExtractor.excludeRegexp(withIncludeRegexp, opts);
        return withExcludedRegexp.stripIndentation().toString();
    }

    private static Text replaceAll(Text text, PluginParamsOpts opts) {
        List fromToOrListOfFromTo = opts.getList(REPLACE_KEY);
        if (fromToOrListOfFromTo.isEmpty()) {
            return text;
        }
        ArrayList replacePairsList = new ArrayList();
        if (fromToOrListOfFromTo.get(0) instanceof List) {
            replacePairsList.addAll(fromToOrListOfFromTo);
        } else {
            replacePairsList.add(fromToOrListOfFromTo);
        }
        Text result = text;
        for (List fromTo : replacePairsList) {
            if (fromTo.size() != 2) {
                throw new IllegalArgumentException("replace expects list with two values [from, to] or a list of pairs [[from1, to1], [from2, to2]]");
            }
            result = result.replaceAll((String)fromTo.get(0), (String)fromTo.get(1));
        }
        return result;
    }

    private static Text cropSurroundedBy(String contentId, Text text, PluginParamsOpts opts) {
        List surroundedBy = opts.getList(SURROUNDED_BY_KEY);
        if (surroundedBy.isEmpty()) {
            return text;
        }
        boolean keepMarker = opts.get(SURROUNDED_BY_KEEP_KEY, false);
        List surroundedBySeparator = opts.getList(SURROUNDED_BY_SEPARATOR_KEY);
        Iterator separatorIt = surroundedBySeparator.iterator();
        String separator = separatorIt.hasNext() ? (String)separatorIt.next() : null;
        Text result = new Text(contentId, "");
        int idx = 0;
        for (String marker : surroundedBy) {
            boolean isLast = idx == surroundedBy.size() - 1;
            Text surroundedCrop = text.startingWithLineContaining(marker);
            surroundedCrop = surroundedCrop.limitToLineContaining(marker, subLine -> "there is no second marker \"" + subLine + "\"" + text.renderInContent());
            if (!keepMarker) {
                surroundedCrop = surroundedCrop.cropOneLineFromStartAndEnd();
            }
            if ((surroundedCrop = surroundedCrop.stripIndentation()).isEmpty()) {
                throw new RuntimeException("no content present after surroundedBy " + marker);
            }
            result = result.append(surroundedCrop);
            if (!isLast && separator != null) {
                result = result.append(separator);
            }
            separator = separatorIt.hasNext() ? (String)separatorIt.next() : separator;
            ++idx;
        }
        return result;
    }

    private static Text cropStart(Text text, PluginParamsOpts opts) {
        String startLine = (String)opts.get(START_LINE_KEY);
        if (startLine == null) {
            return text;
        }
        return text.startingWithLineContaining(startLine);
    }

    private static Text cropEnd(Text text, PluginParamsOpts opts) {
        Number numberOfLines = (Number)opts.get(NUMBER_OF_LINES_KEY);
        if (numberOfLines != null) {
            return text.limitTo(numberOfLines);
        }
        String endLine = (String)opts.get(END_LINE_KEY);
        if (endLine != null) {
            return text.limitToLineContaining(endLine, text::defaultNoLineFoundMessage);
        }
        return text;
    }

    private static Text excludeStart(Text text, PluginParamsOpts opts) {
        Boolean excludeStart = opts.get(EXCLUDE_START_KEY, false);
        Boolean excludeStartEnd = opts.get(EXCLUDE_START_END_KEY, false);
        if (!excludeStart.booleanValue() && !excludeStartEnd.booleanValue()) {
            return text;
        }
        return text.cropOneLineFromStart();
    }

    private static Text excludeEnd(Text text, PluginParamsOpts opts) {
        Boolean excludeEnd = opts.get(EXCLUDE_END_KEY, false);
        Boolean excludeStartEnd = opts.get(EXCLUDE_START_END_KEY, false);
        if (!excludeEnd.booleanValue() && !excludeStartEnd.booleanValue()) {
            return text;
        }
        return text.cropOneLineFromEnd();
    }

    private static Text includeContains(Text text, PluginParamsOpts opts) {
        List<String> texts = opts.getList(INCLUDE_KEY);
        if (texts.isEmpty()) {
            return text;
        }
        return text.includeContains(texts);
    }

    private static Text excludeContains(Text text, PluginParamsOpts opts) {
        List<String> texts = opts.getList(EXCLUDE_KEY);
        if (texts.isEmpty()) {
            return text;
        }
        return text.excludeContains(texts);
    }

    private static Text includeRegexp(Text text, PluginParamsOpts opts) {
        List<String> includeRegexps = opts.getList(INCLUDE_REGEXP_KEY);
        if (includeRegexps.isEmpty()) {
            return text;
        }
        return text.includeRegexp(TextContentExtractor.createListOfPatterns(includeRegexps));
    }

    private static Text excludeRegexp(Text text, PluginParamsOpts opts) {
        List<String> excludeRegexps = opts.getList(EXCLUDE_REGEXP_KEY);
        if (excludeRegexps.isEmpty()) {
            return text;
        }
        return text.excludeRegexp(TextContentExtractor.createListOfPatterns(excludeRegexps));
    }

    private static List<Pattern> createListOfPatterns(List<String> regexps) {
        return regexps.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    private static class Text {
        private final String contentId;
        private final List<String> lines;
        private final boolean hasCroppedStart;

        public Text(String contentId, String text) {
            this(contentId, Arrays.asList(text.split("\n")), false);
        }

        public Text(String contentId, List<String> lines, boolean hasCroppedStart) {
            this.contentId = contentId;
            this.lines = lines;
            this.hasCroppedStart = hasCroppedStart;
        }

        boolean isEmpty() {
            return this.lines.isEmpty();
        }

        Text stripIndentation() {
            String text = StringUtils.stripIndentation(this.toString());
            return text.isEmpty() ? new Text(this.contentId, Collections.emptyList(), false) : new Text(this.contentId, text);
        }

        Text append(Text another) {
            ArrayList<String> newLines = new ArrayList<String>(this.lines);
            newLines.addAll(another.lines);
            return this.newText(newLines);
        }

        Text replaceAll(String from, String to) {
            List<String> replaced = this.lines.stream().map(line -> line.replaceAll(from, to)).collect(Collectors.toList());
            if (replaced.equals(this.lines)) {
                throw new IllegalArgumentException("content was not modified using replace from: <" + from + "> to: <" + to + ">");
            }
            return this.newText(replaced);
        }

        Text append(String line) {
            ArrayList<String> newLines = new ArrayList<String>(this.lines);
            newLines.add(line);
            return this.newText(newLines);
        }

        Text startingWithLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return this.newText(this.lines.subList(lineIdx, this.lines.size()), true);
        }

        Text limitToLineContaining(String subLine, Function<String, String> errorMessageFunc) {
            int lineIdx = this.findLineIdxContaining(subLine, errorMessageFunc);
            return this.newText(this.lines.subList(0, lineIdx + 1));
        }

        Text limitTo(Number numberOfLines) {
            return this.newText(this.lines.subList(0, numberOfLines.intValue()));
        }

        Text cropOneLineFromStartAndEnd() {
            return this.newText(this.lines.subList(1, this.lines.size() - 1));
        }

        Text cropOneLineFromStart() {
            return this.newText(this.lines.subList(1, this.lines.size()));
        }

        Text cropOneLineFromEnd() {
            return this.newText(this.lines.subList(0, this.lines.size() - 1));
        }

        <E> Text include(List<E> inputs, String matchingLabel, BiFunction<String, E, Boolean> predicate) {
            List<String> newLines = this.lines.stream().filter(line -> inputs.stream().anyMatch(input -> (Boolean)predicate.apply((String)line, (Object)input))).collect(Collectors.toList());
            if (newLines.isEmpty()) {
                throw new IllegalArgumentException("there are no lines " + matchingLabel + " " + this.renderListOfStrings(inputs) + this.renderInContent());
            }
            return this.newText(newLines);
        }

        Text includeContains(List<String> texts) {
            return this.include(texts, "containing", String::contains);
        }

        Text includeRegexp(List<Pattern> regexps) {
            return this.include(regexps, "matching regexp", (line, regexp) -> regexp.matcher((CharSequence)line).find());
        }

        <E> Text exclude(List<E> inputs, String matchingLabel, BiFunction<String, E, Boolean> predicate) {
            List<String> newLines = this.lines.stream().filter(line -> inputs.stream().noneMatch(input -> (Boolean)predicate.apply((String)line, (Object)input))).collect(Collectors.toList());
            if (newLines.size() == this.lines.size()) {
                throw new IllegalArgumentException("there are no lines " + matchingLabel + " " + this.renderListOfStrings(inputs) + this.renderInContent());
            }
            return this.newText(newLines);
        }

        Text excludeContains(List<String> texts) {
            return this.exclude(texts, "containing", String::contains);
        }

        Text excludeRegexp(List<Pattern> regexps) {
            return this.exclude(regexps, "matching regexp", (line, regexp) -> regexp.matcher((CharSequence)line).find());
        }

        private Text newText(List<String> lines) {
            return new Text(this.contentId, lines, false);
        }

        private Text newText(List<String> lines, boolean hasCroppedStart) {
            return new Text(this.contentId, lines, hasCroppedStart);
        }

        private int findLineIdxContaining(String subLine) {
            return this.findLineIdxContaining(subLine, this::defaultNoLineFoundMessage);
        }

        private int findLineIdxContaining(String subLine, Function<String, String> errorMessageFunc) {
            int i;
            int n = i = this.hasCroppedStart ? 1 : 0;
            while (i < this.lines.size()) {
                if (this.lines.get(i).contains(subLine)) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException(errorMessageFunc.apply(subLine));
        }

        public String toString() {
            return String.join((CharSequence)"\n", this.lines);
        }

        private String renderListOfStrings(List<?> list) {
            return list.stream().map(p -> "<" + p.toString() + ">").collect(Collectors.joining(", "));
        }

        private String defaultNoLineFoundMessage(String subLine) {
            return "there is no line containing \"" + subLine + "\"" + this.renderInContent();
        }

        private String renderInContent() {
            return " in <" + this.contentId + ">:\n" + this;
        }
    }
}

