/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.html;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.utils.UrlUtils;

public class IframeIncludePlugin
implements IncludePlugin {
    private String userUrl;

    @Override
    public String id() {
        return "iframe";
    }

    @Override
    public IncludePlugin create() {
        return new IframeIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        DocElement iframe = new DocElement("Iframe");
        this.userUrl = pluginParams.getFreeParam();
        String urlToUse = UrlUtils.isExternal(this.userUrl) ? this.userUrl : componentsRegistry.docStructure().fullUrl(this.userUrl);
        iframe.addProp("src", urlToUse);
        pluginParams.getOpts().assignToDocElement(iframe);
        return PluginResult.docElement(iframe);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        if (!UrlUtils.isExternal(this.userUrl)) {
            return Stream.of(AuxiliaryFile.runTime(componentsRegistry.resourceResolver().fullPath(this.userUrl), Paths.get(this.userUrl, new String[0])));
        }
        return Stream.empty();
    }
}

