/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.markup;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.Plugin;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.file.ManipulatedSnippetContentProvider;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;

public abstract class MarkdownBasePlugin
implements Plugin {
    private static final String FIRST_AVAILABLE_PARAM_KEY = "firstAvailable";
    private static final String USAGE_MESSAGE = "use either <firstAvailable> or free form param to specify file to include";
    protected Path markdownPathUsed;
    protected MarkupParserResult parserResult;

    @Override
    public String id() {
        return "markdown";
    }

    @Override
    public PluginParamsDefinition parameters() {
        return new PluginParamsDefinition().add(FIRST_AVAILABLE_PARAM_KEY, PluginParamType.LIST_OR_SINGLE_STRING, "path(s) of files to consider to include, first one will be included. Use this to provide an alternative docs for on-prem documentation").add(ManipulatedSnippetContentProvider.paramsDefinition);
    }

    @Override
    public void preprocess(ComponentsRegistry componentsRegistry, Path markupPath, PluginParams pluginParams) {
        ResourcesResolver resourcesResolver = componentsRegistry.resourceResolver();
        MarkupParser parser = componentsRegistry.defaultParser();
        this.markdownPathUsed = this.selectMarkdown(componentsRegistry.resourceResolver(), pluginParams);
        String content = this.modifiedContent(this.markdownPathUsed.toString(), resourcesResolver.textContent(this.markdownPathUsed), pluginParams);
        this.parserResult = parser.parse(markupPath, content);
    }

    private String modifiedContent(String id, String fullContent, PluginParams pluginParams) {
        ManipulatedSnippetContentProvider contentProvider = new ManipulatedSnippetContentProvider(id, fullContent, pluginParams);
        return contentProvider.snippetContent();
    }

    private Path selectMarkdown(ResourcesResolver resourcesResolver, PluginParams pluginParams) {
        if (pluginParams.getOpts().has(FIRST_AVAILABLE_PARAM_KEY) && !pluginParams.getFreeParam().isEmpty()) {
            throw new IllegalArgumentException("use either <firstAvailable> or free form param to specify file to include, but not both");
        }
        List optionalPaths = pluginParams.getOpts().getList(FIRST_AVAILABLE_PARAM_KEY);
        if (pluginParams.getFreeParam().isEmpty() && optionalPaths.isEmpty()) {
            throw new IllegalArgumentException("use either <firstAvailable> or free form param to specify file to include, but none was specified");
        }
        return optionalPaths.stream().filter(p -> resourcesResolver.canResolve(p.toString())).findFirst().map(p -> resourcesResolver.fullPath(p.toString())).orElseGet(() -> resourcesResolver.fullPath(pluginParams.getFreeParam()));
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.markdownPathUsed)), this.parserResult.getAuxiliaryFiles().stream());
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }
}

